% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RastProcessing.R
\name{crop.all}
\alias{crop.all}
\title{Cropping tiff data}
\usage{
crop.all(
  envrmt = .GlobalEnv$envrmt,
  method = "MB_Timeseries",
  crs = NULL,
  ext = NULL,
  overwrite = FALSE,
  ...
)
}
\arguments{
\item{envrmt}{variable name of your envrmt list created using climodr's `envi.create` function. Default = envrmt.}

\item{method}{character. Use "MB_Timeseries" for now. More methods are planned and will be added in future.}

\item{crs}{Coordinate reference system Used to crop all images in folder_path. If crs
it will automatically reprojected into this one. Default: crs of smallest Extent.}

\item{ext}{SpatRaster, SpatVector or SpatExtent. Extent all data is cropped into. Default: Smallest Extent in folder_path.}

\item{overwrite}{logical. Should existing files with the same filename be
overwritten? Default = FALSE}

\item{...}{arguments passed down from other functions.}
}
\value{
SpatRaster-Stack. Also saved to /workflow/rworkflow
}
\description{
Crops input data to the extent size and reprojects them into project Coordinate reference system.
}
\examples{
#create climodr environment and allow terra-functions to use 70\% of RAM
envrmt <- envi.create(proj_path = tempdir(),
                      memfrac = 0.7)

# Load the climodr example data into the current climodr environment
clim.sample(envrmt = envrmt)

# Crop all raster bands
crop.all(envrmt = envrmt,
         method = "MB_Timeseries",
         overwrite = TRUE)

}
\seealso{
`fin.csv`, `calc.indices`
}
