% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Environment.R
\name{envi.create}
\alias{envi.create}
\title{Create climodr environment}
\usage{
envi.create(proj_path = tempdir(), memfrac = NULL, ...)
}
\arguments{
\item{proj_path}{character. Path to project directory. Climodr will work exclusively in this folder and create all project folders in here.}

\item{memfrac}{numeric. Value between 0 and 0.9. The fraction of RAM that may be used by the terra package}

\item{...}{arguments passed down from other functions.}
}
\value{
list. Contains all paths to each folder in the project directory. Necessary for climodr to operate its functions.
}
\description{
Creates an environment climodr will use during the calculation process. A list is returned with all paths to all folders.
After creating the environment, all necessary data should be stored into the depending Input sub-folders.
There is also an additional temp-folder, where temporary data is stored, which can be deleted after not being used anymore.
}
\examples{
# create climodr environment and allow terra-functions to use 70\% of RAM
envrmt <- envi.create(proj_path = tempdir(),
                      memfrac = 0.7)

}
