% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots-palettes.R
\name{getLinetypePalette}
\alias{getLinetypePalette}
\title{Get a linetype palette for clinical
visualizations.}
\usage{
getLinetypePalette(
  n = NULL,
  x = NULL,
  includeNA = FALSE,
  palette = clinLinetypes
)
}
\arguments{
\item{n}{Integer of length 1, number of elements in palette.}

\item{x}{Vector with elements used for palette.
If factor, the levels are used, otherwise the unique elements of the vector.
Missing values are automatically removed, excepted if
\code{includeNA} is set to TRUE.}

\item{includeNA}{Logical (FALSE by default), 
should NA elements be retained in the palette in case
\code{x} is specified?}

\item{palette}{A vector of custom linetypes,
or a function returning this vector from a specific
number of linetypes.\cr
Default is the \code{\link{clinLinetypes}} linetype palette.}
}
\value{
Vector with linetypes,
named with the elements in \code{x} if \code{x} is specified.
}
\description{
Get a linetype palette of specified length,
either from a vector of names for the palette, or
from a specified length.
}
\details{
Note that 7 unique symbols are available at maximum
(replicated if necessary).
}
\examples{
# extract longest linetype palette available
getLinetypePalette(n = 6)
# extract palette for a vector
getLinetypePalette(x = paste('treatment', 1:4))
# include missing
getLinetypePalette(x = c(NA_character_, "group1"), includeNA = TRUE)
getLinetypePalette(x = c(NA_character_, "group1"), includeNA = FALSE)
# set custom linetypes
lty <- getColorPalette(n = 3, palette = c("twodash", "dashed"))
}
\author{
Laure Cougnaud and Michela Pasetto
}
