% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_titles_footnotes.R
\name{new_title_footnote}
\alias{new_title_footnote}
\title{Create a new title or footnote flextable}
\usage{
new_title_footnote(x, sect = c("titles", "footnotes", "footnote_page"))
}
\arguments{
\item{x}{a list of character vectors, no more than 3 elements to a vector.}

\item{sect}{Either "titles" or "footnotes"}
}
\value{
A flextable object
}
\description{
Create a new title or footnote flextable
}
\examples{

title <- new_title_footnote(
  list(
    # We'll add tools to automate paging
    c("Protocol: CDISCPILOT01", "Page {PAGE} of {NUMPAGES}"),
    c("Table 14-2.01"),
    c("Summary of Demographic and Baseline Characteristics")
  ),
  "titles"
)

footnote <- new_title_footnote(
  list(
    # We'll add tools to automate paging
    c("Page {PAGE}", "Total Pages: {NUMPAGES}")
  ),
  "footnotes"
)

}
