% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctg_data_report.R
\name{ctg_data_report}
\alias{ctg_data_report}
\title{Generate a Comprehensive Clinical Trial Data Report}
\usage{
ctg_data_report(
  ctg_data,
  title = "Clinical Trial Data Report",
  author = "Author Name",
  output_file = "./report.html",
  color_palette = c("#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd", "#8c564b"),
  theme = "cerulean",
  include_data_quality = TRUE,
  include_interactive_plots = TRUE,
  custom_footer = NULL
)
}
\arguments{
\item{ctg_data}{A data frame containing clinical trial data. Required columns include:
\itemize{
  \item \code{Study Status}: Current status of each study (e.g., \code{"Completed"}, \code{"Ongoing"})
  \item \code{Enrollment}: Number of participants in each study
  \item \code{Start Date}: The date each study began
  \item \code{Completion Date}: The date each study ended or is expected to end
  \item \code{Phases}: The phase of each clinical trial (e.g., \code{"Phase 1"}, \code{"Phase 2"})
  \item \code{Funder Type}: The type of organization funding each study
  \item \code{Study Type}: The type of each study (e.g., \code{"Interventional"}, \code{"Observational"})
}}

\item{title}{Character string. The title of the report.
Default is \code{"Clinical Trial Data Report"}.}

\item{author}{Character string. The name of the report author.
Default is \code{"Author Name"}.}

\item{output_file}{Character string. The file path where the HTML report will be saved.
Default is \code{"./report.html"}. You can specify a different path if needed.}

\item{color_palette}{Character vector. A set of colors to be used in the report's visualizations.
Default is a preset palette of 6 colors. You can provide your own color codes for customization.}

\item{theme}{Character string. The Bootstrap theme for the HTML report.
Default is \code{"cerulean"}. Other options include \code{"default"}, \code{"journal"},
\code{"flatly"}, \code{"readable"}, \code{"spacelab"}, \code{"united"}, \code{"cosmo"},
\code{"lumen"}, \code{"paper"}, \code{"sandstone"}, \code{"simplex"}, and \code{"yeti"}.}

\item{include_data_quality}{Logical. Whether to include a data quality assessment section.
Default is \code{TRUE}. Set to \code{FALSE} if you want to skip this section.}

\item{include_interactive_plots}{Logical. Whether to generate interactive plots using plotly.
Default is \code{TRUE}. Set to \code{FALSE} for static plots, which may be preferred for certain use cases.}

\item{custom_footer}{Character string or \code{NULL}. A custom footer for the report.
If \code{NULL} (default), a standard footer crediting the ClinTrialX package is used.}
}
\value{
This function doesn't return a value, but generates an HTML report at the specified location.
  It prints a message with the path to the generated report upon successful completion.
}
\description{
This function creates a detailed, visually appealing HTML report from clinical trial data.
It automates the process of data analysis and visualization, providing insights into various
aspects of clinical trials such as study status, enrollment, duration, and funding sources.

Visit here for an example report - \url{https://www.indraneelchakraborty.com/clintrialx/report.html}.
}
\details{
The function performs these key steps:

1. Package Management:
   \itemize{
   \item Checks for required packages and offers to install any that are missing.
   \item Required packages: \code{rmarkdown}, \code{ggplot2}, \code{plotly}, \code{dplyr},
     \code{lubridate}, \code{reactable}, \code{scales}, \code{RColorBrewer}, \code{htmltools}.
     }

2. Report Generation:
   \itemize{
   \item Creates a temporary R Markdown file with the report content.
   \item Includes an executive summary with key statistics.
   \item Provides an interactive data table for easy exploration of the dataset.
   }

3. Data Visualization:
   \itemize{
   \item Study Status Distribution: Bar chart showing the count of studies in each status.
   \item Enrollment by Study Phase: Box plot displaying enrollment numbers across different study phases.
   \item Study Duration Timeline: Scatter plot showing the relationship between study start dates and durations.
   \item Funding Sources and Study Types: Stacked bar chart illustrating the proportion of study types for each funder type.
   }

4. Optional Sections:
   \itemize{
   \item Data Quality Assessment: Bar chart showing the percentage of missing data for each variable (if enabled).
   \item Interactive Plots: Uses plotly to create interactive versions of all plots (if enabled).
   }

5. Report Finalization:
   \itemize{
   \item Renders the R Markdown file to an HTML report.
   \item Cleans up temporary files.
   }
}
\section{Tips for Users}{

\itemize{
\item Ensure your data frame has all required columns before using this function.
\item Experiment with different themes to find the most suitable look for your report.
\item If you encounter any package installation issues, you may need to install them manually.
\item For large datasets, setting \code{include_interactive_plots = FALSE} may improve performance.
\item Custom color palettes can be used to match your organization's branding.
\item The generated report is self-contained and can be easily shared or published on the web.
}
}

\seealso{
\url{https://www.indraneelchakraborty.com/clintrialx/} for more information about the ClinTrialX package.
}
