% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_trials.R
\name{ctg_get_fields}
\alias{ctg_get_fields}
\title{Query ClinicalTrials.gov API}
\usage{
ctg_get_fields(
  condition = NULL,
  location = NULL,
  title = NULL,
  intervention = NULL,
  status = NULL,
  page_size = 20
)
}
\arguments{
\item{condition}{A character string specifying the medical condition to search for.
This will filter the results to studies related to the given condition.}

\item{location}{A character string specifying the location (e.g., city or country)
to search in. This will filter the results to studies conducted in the specified
location.}

\item{title}{A character string specifying keywords to search for in study title.
This will filter the results to studies with title that include the specified
keywords.}

\item{intervention}{A character string specifying the intervention or treatment
to search for. This will filter the results to studies involving the specified
intervention.}

\item{status}{A character vector specifying the overall status of the studies.
Valid values include:
\itemize{
  \item \code{ACTIVE_NOT_RECRUITING} - Studies that are actively conducting but not
        recruiting participants.
  \item \code{COMPLETED} - Studies that have completed all phases.
  \item \code{ENROLLING_BY_INVITATION} - Studies that are enrolling participants
        by invitation only.
  \item \code{NOT_YET_RECRUITING} - Studies that have not yet started recruiting.
  \item \code{RECRUITING} - Studies that are actively recruiting participants.
  \item \code{SUSPENDED} - Studies that are temporarily halted.
  \item \code{TERMINATED} - Studies that have been terminated before completion.
  \item \code{WITHDRAWN} - Studies that have been withdrawn before enrollment.
  \item \code{AVAILABLE} - Studies that are available.
  \item \code{NO_LONGER_AVAILABLE} - Studies that are no longer available.
  \item \code{TEMPORARILY_NOT_AVAILABLE} - Studies that are temporarily not available.
  \item \code{APPROVED_FOR_MARKETING} - Studies that have been approved for marketing.
  \item \code{WITHHELD} - Studies that have data withheld.
  \item \code{UNKNOWN} - Studies with an unknown status.
}}

\item{page_size}{An integer specifying the number of results per page. The default
value is 20. The maximum allowed value is 1,000. If a value greater than 1,000
is specified, it will be coerced to 1,000. If not specified, the default value
will be used.}
}
\value{
A tibble containing the query results. Each row represents a study, and the columns
        correspond to the study details returned by the API.
}
\description{
This function sends a query to the ClinicalTrials.gov API and returns the results as a tibble.
Users can specify various parameters to filter the results, and if a parameter is not provided,
it will be omitted from the query.
}
\details{
This function can return up to 1,000 results.


The function constructs a query to the ClinicalTrials.gov API using the provided parameters.
It supports filtering by condition, location, title keywords, intervention, and overall status.
The function handles the API response, checks for errors, and parses the results into a tibble.
}
\examples{
# Query for studies related to "diabetes" in "Kolkata" with the status "RECRUITING"
ctg_get_fields(condition = "diabetes", location = "Kolkata",
                                 status = "RECRUITING")


# Query for studies with "vaccine" in the title and the status "COMPLETED"
ctg_get_fields(title = "vaccine", status = "COMPLETED", page_size = 50)


}
