% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_specific_trial_data.R
\name{ctg_get_nct}
\alias{ctg_get_nct}
\title{Fetch Clinical Trial Data Based on NCT ID}
\usage{
ctg_get_nct(nct_ids, fields = NULL)
}
\arguments{
\item{nct_ids}{A character vector of one or more NCT IDs (e.g., "NCT04000165") for the clinical trials to fetch.}

\item{fields}{A character vector specifying the fields to retrieve. If NULL (default), all available fields are fetched. If specified, it must be a subset of the available fields.}
}
\value{
A tibble containing the clinical trial data with columns matching the requested fields.
}
\description{
Retrieves data for one or more clinical trials from the ClinicalTrials.gov API based on their NCT ID(s).
}
\details{
This function allows you to specify one or more NCT IDs and optionally select specific fields of interest. It fetches the relevant data and returns it as a tibble.


The function constructs a request for each NCT ID, specifying the desired fields. It uses a progress bar to show the progress of fetching data for multiple trials.
The data is returned as a tibble with columns corresponding to the requested fields. If any fetches fail or if the API response contains columns not requested, warnings will be issued.

Ensure that the \code{fields} parameter contains valid field names as specified in the guide below. Invalid fields will result in an error.
}
\section{Field Names Guide}{

The following are the available fields you can request from ClinicalTrials.gov:
  \code{NCT Number},
  \code{Study Title},
  \code{Study URL},
  \code{Acronym},
  \code{Study Status},
  \code{Brief Summary},
  \code{Study Results},
  \code{Conditions},
  \code{Interventions},
  \code{Primary Outcome Measures},
  \code{Secondary Outcome Measures},
  \code{Other Outcome Measures},
  \code{Sponsor},
  \code{Collaborators},
  \code{Sex},
  \code{Age},
  \code{Phases},
  \code{Enrollment},
  \code{Funder Type},
  \code{Study Type},
  \code{Study Design},
  \code{Other IDs},
  \code{Start Date},
  \code{Primary Completion Date},
  \code{Completion Date},
  \code{First Posted},
  \code{Results First Posted},
  \code{Last Update Posted},
  \code{Locations},
  \code{Study Documents}
}

\examples{
# Fetch data for a single NCT ID
trial_data <- ctg_get_nct("NCT04000165")
trial_data

# Fetch data for multiple NCT IDs
multiple_trials <- ctg_get_nct(c("NCT04000165", "NCT04002440"))
multiple_trials

# Fetch data for multiple NCT IDs with specific fields
specific_fields <- ctg_get_nct(
  c("NCT04000165", "NCT04002440"),
  fields = c("NCT Number", "Study Title", "Study Status")
)
specific_fields

}
