\name{adult_adhd_self_report_scale}
\alias{adult_adhd_self_report_scale}
\title{
Adult Self-Report Scale (ASRS-v1.1) for ADHD
}
\description{
Calculates the score for Part A of the World Health Organization (WHO) Adult Self-Report Scale (ASRS-v1.1) Screener for ADHD. This 6-item tool screens for Attention-Deficit/Hyperactivity Disorder in adults.
}
\usage{
adult_adhd_self_report_scale(q1_trouble_wrapping_up,
q2_difficulty_getting_organized,
q3_problems_remembering_appointments,
q4_procrastinate_difficult_tasks,
q5_fidgety, q6_overly_active)
}
\arguments{
  \item{q1_trouble_wrapping_up}{
Numeric (0-4). How often do you have trouble wrapping up the final details of a project, once the challenging parts have been done?
}
  \item{q2_difficulty_getting_organized}{
Numeric (0-4). How often do you have difficulty getting things in order when you have to do a task that requires organization?
}
  \item{q3_problems_remembering_appointments}{
Numeric (0-4). How often do you have problems remembering appointments or obligations?
}
  \item{q4_procrastinate_difficult_tasks}{
Numeric (0-4). When you have a task that requires a lot of thought, how often do you avoid or delay getting started?
}
  \item{q5_fidgety}{
Numeric (0-4). How often do you fidget or squirm with your hands or feet when you have to sit down for a long time?
}
  \item{q6_overly_active}{
Numeric (0-4). How often do you feel overly active and compelled to do things, like you were driven by a motor?
}
}
\details{
\strong{Scoring Key:}
0 = Never
1 = Rarely
2 = Sometimes
3 = Often
4 = Very Often

\strong{Thresholds:}
Questions 1-3 are considered positive if the response is "Sometimes", "Often", or "Very Often" (Score >= 2).
Questions 4-6 are considered positive if the response is "Often" or "Very Often" (Score >= 3).
}
\value{
A list containing:
\item{Part_A_Score}{The count of positive items (Range 0-6).}
\item{Screening_Result}{"Screening Positive" if 4 or more items are positive, otherwise "Screening Negative".}
}
\references{
Kessler RC, Adler L, Ames M, et al. The World Health Organization Adult ADHD Self-Report Scale (ASRS): a short screening scale for use in the general population. Psychol Med. 2005;35(2):245-56.
}
\examples{

# Example 1: Positive Screen
# Q1-Q3: Often (3), Q4-Q6: Often (3) -> All positive
adult_adhd_self_report_scale(3, 3, 3, 3, 3, 3)

# Example 2: Negative Screen
# All responses "Rarely" (1)
adult_adhd_self_report_scale(1, 1, 1, 1, 1, 1)
}
