\name{aims65_upper_gi_bleed}
\alias{aims65_upper_gi_bleed}
\title{
AIMS65 Score for Upper GI Bleeding Mortality
}
\description{
Calculates the AIMS65 score to predict in-hospital mortality in patients with acute upper gastrointestinal bleeding (UGIB). The acronym stands for Albumin, INR, Mental status, Systolic blood pressure, and age 65.
}
\usage{
aims65_upper_gi_bleed(albumin_g_dl, inr, altered_mental_status, sbp_mmhg, age_years)
}
\arguments{
  \item{albumin_g_dl}{
Numeric. Serum albumin level in g/dL. (< 3.0 g/dL adds +1 point).
}
  \item{inr}{
Numeric. International Normalized Ratio. (> 1.5 adds +1 point).
}
  \item{altered_mental_status}{
Numeric (0 or 1). Presence of altered mental status (GCS < 14 or disorientation). (1 = Yes, +1 point).
}
  \item{sbp_mmhg}{
Numeric. Systolic blood pressure in mmHg. (<= 90 mmHg adds +1 point).
}
  \item{age_years}{
Numeric. Patient age in years. (>= 65 years adds +1 point).
}
}
\value{
A list containing:
\item{Total_Score}{The calculated AIMS65 score (Range 0-5).}
\item{In_Hospital_Mortality_Risk}{Estimated mortality percentage based on the validation study.}
\item{Risk_Stratification}{General classification (High Risk if Score >= 2).}
}
\references{
Saltzman JR, Tabak YP, Hyett BH, Sun X, Travis AC, Johannes RS. A simple risk score accurately predicts in-hospital mortality, length of stay, and cost in acute upper GI bleeding. Gastrointest Endosc. 2011;74(6):1215-1224. doi:10.1016/j.gie.2011.06.024
}
\examples{

# Example 1: High Risk
# Albumin 2.5 (+1), INR 2.0 (+1), Alert (0), SBP 85 (+1), Age 70 (+1)
# Score = 4
aims65_upper_gi_bleed(2.5, 2.0, 0, 85, 70)

# Example 2: Low Risk
# Albumin 4.0 (0), INR 1.0 (0), Alert (0), SBP 120 (0), Age 40 (0)
# Score = 0
aims65_upper_gi_bleed(4.0, 1.0, 0, 120, 40)
}
