\name{cha2ds2_vasc_score}
\alias{cha2ds2_vasc_score}
\title{
CHA2DS2-VASc Score for Atrial Fibrillation Stroke Risk
}
\description{
Calculates the CHA2DS2-VASc score to estimate the risk of stroke in patients with non-valvular atrial fibrillation. This score refines the older CHADS2 score by extending the risk factors to include age 65-74, vascular disease, and female sex. It is widely used to determine the indication for oral anticoagulation therapy.
}
\usage{
cha2ds2_vasc_score(age, sex, chf_history, hypertension_history,
                   stroke_tia_history, vascular_disease_history, diabetes_history)
}
\arguments{
  \item{age}{
Numeric. Patient age in years. (65-74: +1 point; >=75: +2 points).
}
  \item{sex}{
String. Patient sex ("Male" or "Female"). (Female: +1 point).
}
  \item{chf_history}{
Numeric (0 or 1). Congestive heart failure history. (1 = Yes, +1 point).
}
  \item{hypertension_history}{
Numeric (0 or 1). Hypertension history. (1 = Yes, +1 point).
}
  \item{stroke_tia_history}{
Numeric (0 or 1). History of Stroke, TIA, or Thromboembolism. (1 = Yes, +2 points).
}
  \item{vascular_disease_history}{
Numeric (0 or 1). Vascular disease history (prior MI, peripheral artery disease, or aortic plaque). (1 = Yes, +1 point).
}
  \item{diabetes_history}{
Numeric (0 or 1). Diabetes mellitus history. (1 = Yes, +1 point).
}
}
\value{
A list containing:
\item{CHA2DS2_VASc_Score}{The calculated score (Range 0-9).}
\item{Annual_Stroke_Risk_No_Anticoagulation}{Estimated annual stroke risk percentage based on Lip et al. (2010).}
\item{Recommendation}{Clinical guidance regarding anticoagulation based on sex-specific thresholds.}
}
\references{
Lip GY, Nieuwlaat R, Pisters R, et al. Refining clinical risk stratification for predicting stroke and thromboembolism in atrial fibrillation using a novel risk factor-based approach: the euro heart survey on atrial fibrillation. Chest. 2010;137(2):263-272. doi:10.1378/chest.09-1584
}
\examples{

# Example 1: High Risk Male
# 76yo (+2), HTN (+1), No other factors
# Score = 3
cha2ds2_vasc_score(76, "male", 0, 1, 0, 0, 0)

# Example 2: Low Risk Female
# 50yo, Female (+1), No other risk factors
# Score = 1 (Low risk for females)
cha2ds2_vasc_score(50, "female", 0, 0, 0, 0, 0)
}
