\name{dast_10_screening}
\alias{dast_10_screening}
\title{
Drug Abuse Screening Test (DAST-10)
}
\description{
Calculates the DAST-10 score, a brief 10-item screening tool used to identify drug use problems in the past 12 months. It is designed for use in clinical and non-clinical settings.
}
\usage{
dast_10_screening(used_drugs_non_medical, abuse_multiple_drugs,
                  able_to_stop_when_wanted, blackouts_flashbacks, feel_guilty,
                  spouse_parents_complain, neglected_family, illegal_activities,
                  withdrawal_symptoms, medical_problems)
}
\arguments{
  \item{used_drugs_non_medical}{
Numeric (0 or 1). Have you used drugs other than those required for medical reasons? (1 = Yes).
}
  \item{abuse_multiple_drugs}{
Numeric (0 or 1). Do you abuse more than one drug at a time? (1 = Yes).
}
  \item{able_to_stop_when_wanted}{
Numeric (0 or 1). Are you always able to stop using drugs when you want to? (1 = Yes, 0 = No). **Note: "No" scores 1 point.**
}
  \item{blackouts_flashbacks}{
Numeric (0 or 1). Have you had "blackouts" or "flashbacks" as a result of drug use? (1 = Yes).
}
  \item{feel_guilty}{
Numeric (0 or 1). Do you ever feel bad or guilty about your drug use? (1 = Yes).
}
  \item{spouse_parents_complain}{
Numeric (0 or 1). Does your spouse (or parents) ever complain about your involvement with drugs? (1 = Yes).
}
  \item{neglected_family}{
Numeric (0 or 1). Have you neglected your family because of your use of drugs? (1 = Yes).
}
  \item{illegal_activities}{
Numeric (0 or 1). Have you engaged in illegal activities in order to obtain drugs? (1 = Yes).
}
  \item{withdrawal_symptoms}{
Numeric (0 or 1). Have you ever experienced withdrawal symptoms (felt sick) when you stopped taking drugs? (1 = Yes).
}
  \item{medical_problems}{
Numeric (0 or 1). Have you had medical problems as a result of your drug use (e.g., memory loss, hepatitis, convulsions, bleeding)? (1 = Yes).
}
}
\value{
A list containing:
\item{DAST_10_Score}{The calculated total score (Range 0-10).}
\item{Severity_Level}{Interpretation (No problems, Low, Moderate, Substantial, Severe).}
\item{Suggested_Action}{Clinical recommendation based on the severity level.}
}
\references{
Skinner HA. The drug abuse screening test. Addict Behav. 1982;7(4):363-371. doi:10.1016/0306-4603(82)90005-3
}
\examples{

# Example 1: Substantial Problem
# Used drugs, Multiple drugs, Can't stop (0), Guilt, Complaints, Withdrawal
# Score = 1+1+1+0+1+1+0+0+1+0 = 6
dast_10_screening(1, 1, 0, 0, 1, 1, 0, 0, 1, 0)

# Example 2: Low Level
# Used drugs only
# Score = 1
dast_10_screening(1, 0, 1, 0, 0, 0, 0, 0, 0, 0)
}
