\name{gupta_respiratory_failure_risk}
\alias{gupta_respiratory_failure_risk}
\title{
Gupta Postoperative Respiratory Failure Risk
}
\description{
Calculates the percentage risk of postoperative respiratory failure (mechanical ventilation > 48h or unplanned reintubation) based on the Gupta et al. (2011) model. This calculator uses five preoperative predictors: procedure type, ASA status, functional dependence, sepsis, and emergency status.
}
\usage{
gupta_respiratory_failure_risk(procedure_type, asa_class, functional_status,
                               emergency_case, sepsis_status)
}
\arguments{
  \item{procedure_type}{
String. Surgical procedure category. Valid options include:
"anorectal", "aortic", "bariatric", "brain", "breast", "cardiac", "ent", "foregut_hepatopancreatobiliary", "gallbladder_appendix_adrenal_spleen", "hernia_ventral_inguinal", "intestinal", "neck_thyroid_parathyroid", "obgyn", "orthopedic", "other_abdominal", "peripheral_vascular", "skin", "spine", "thoracic_non_cardiac", "urology", "vein".
}
  \item{asa_class}{
Numeric. ASA Physical Status Classification (1-5).
}
  \item{functional_status}{
String. Preoperative functional status. Options: "independent", "partially_dependent", "totally_dependent".
}
  \item{emergency_case}{
Numeric (0 or 1). Is the surgery an emergency? (1 = Yes).
}
  \item{sepsis_status}{
String. Preoperative sepsis category. Options: "none", "sirs", "sepsis", "septic_shock".
}
}
\value{
A list containing:
\item{Respiratory_Failure_Risk_Percent}{The estimated probability of postoperative respiratory failure.}
}
\references{
Gupta H, Gupta PK, Fang X, et al. Development and validation of a risk calculator predicting postoperative respiratory failure. Chest. 2011;140(5):1207-1215. doi:10.1378/chest.11-0466
}
\examples{

# Example 1: High Risk (Emergency Aortic)
# Aortic, ASA 4, Dependent, Sepsis, Emergency
gupta_respiratory_failure_risk("aortic", 4, "totally_dependent", 1, "sepsis")

# Example 2: Low Risk (Elective Hernia)
# Hernia, ASA 2, Independent, No Sepsis, Elective
gupta_respiratory_failure_risk("hernia_ventral_inguinal", 2, "independent", 0, "none")
}
