\name{metroticket_hcc_survival}
\alias{metroticket_hcc_survival}
\title{
Metroticket Calculator for HCC Survival (Up-to-7 Criteria)
}
\description{
Calculates the "Up-to-7" score and estimates 5-year overall survival for patients with Hepatocellular Carcinoma (HCC) considered for liver transplantation. This tool identifies patients exceeding the Milan criteria who may still achieve favorable outcomes. The "Up-to-7" criteria are met if the sum of the size of the largest tumor (in cm) and the number of tumors is <= 7, provided there is no microvascular invasion.
}
\usage{
metroticket_hcc_survival(largest_nodule_size_mm, number_of_nodules,
                         vascular_invasion)
}
\arguments{
  \item{largest_nodule_size_mm}{
Numeric. Diameter of the largest tumor nodule in millimeters.
}
  \item{number_of_nodules}{
Numeric. Total number of tumor nodules.
}
  \item{vascular_invasion}{
String. Presence of microvascular invasion. Options: "absent", "present", "unknown".
}
}
\value{
A list containing:
\item{Up_To_Seven_Score}{The calculated score (Size in cm + Number).}
\item{Predicted_5_Year_Survival}{Estimated survival percentage based on the Mazzaferro et al. (2009) derivation cohort.}
\item{Criteria_Status}{Indicates if the patient meets the "Up-to-7" criteria.}
}
\references{
Mazzaferro V, Llovet JM, Miceli R, et al. Predicting survival after liver transplantation in patients with hepatocellular carcinoma beyond the Milan criteria: a retrospective, exploratory analysis. Lancet Oncol. 2009;10(1):35-43. doi:10.1016/S1470-2045(08)70284-5
}
\examples{

# Example 1: Meets Criteria
# 30mm (3cm) tumor, 3 nodules, No invasion
# Score = 3 + 3 = 6 (<= 7)
metroticket_hcc_survival(30, 3, "absent")

# Example 2: Exceeds Criteria
# 50mm (5cm) tumor, 3 nodules, No invasion
# Score = 5 + 3 = 8 (> 7)
metroticket_hcc_survival(50, 3, "absent")

# Example 3: High Risk
# 30mm tumor, 2 nodules, Vascular invasion present
metroticket_hcc_survival(30, 2, "present")
}
