\name{modified_mallampati_classification}
\alias{modified_mallampati_classification}
\title{
Modified Mallampati Classification
}
\description{
Retrieves the clinical description for the Modified Mallampati Classification. This system is used to predict the ease of endotracheal intubation based on the visibility of oropharyngeal structures.
}
\usage{
modified_mallampati_classification(class_grade)
}
\arguments{
  \item{class_grade}{
Numeric (1-4). The assigned Mallampati Class.
1: Full visibility (Soft palate, fauces, uvula, pillars).
2: Partial visibility (Soft palate, fauces, uvula).
3: Limited visibility (Soft palate, base of uvula).
4: No visibility (Hard palate only).
}
}
\value{
A list containing:
\item{Mallampati_Class}{The formatted class string.}
\item{Visibility}{Description of visible anatomical structures.}
\item{Intubation_Difficulty}{Estimated difficulty of intubation.}
}
\references{
Samsoon GL, Young JR. Difficult tracheal intubation: a retrospective study. Anaesthesia. 1987;42(5):487-490. doi:10.1111/j.1365-2044.1987.tb04039.x
}
\examples{

# Example 1: Class I (Easy)
modified_mallampati_classification(1)

# Example 2: Class IV (Difficult)
modified_mallampati_classification(4)
}
