\name{scarf_score}
\alias{scarf_score}
\title{
Sequential Clinical Assessment of Respiratory Function (SCARF) Score
}
\description{
Calculates the SCARF score to predict the risk of progression to severe pneumonia (composite of mechanical ventilation or death) in patients hospitalized with COVID-19. The score is based on respiratory rate, oxygen saturation, and the number of lung lobes affected on imaging.
}
\usage{
scarf_score(respiratory_rate, spo2, lobes_affected)
}
\arguments{
  \item{respiratory_rate}{
Numeric. Respiratory rate in breaths per minute.
< 20: 0 pts.
20 - 24: 2 pts.
25 - 30: 4 pts.
> 30: 6 pts.
}
  \item{spo2}{
Numeric. Oxygen saturation percentage (SpO2).
> 96: 0 pts.
94 - 96: 2 pts.
90 - 93: 4 pts.
< 90: 6 pts.
}
  \item{lobes_affected}{
Numeric. Number of lung lobes affected on Chest X-ray or CT (0-5).
0 - 1: 0 pts.
2 - 3: 2 pts.
> 3: 5 pts.
}
}
\value{
A list containing:
\item{SCARF_Score}{The calculated total score (Range 0-17).}
\item{Risk_Category}{Classification (Low, Moderate, High).}
\item{Risk_of_Severe_Pneumonia}{Estimated probability of progression to severe pneumonia within 14 days.}
}
\references{
Doshi A, Shah P, Jariwala P, et al. Sequential Clinical Assessment of Respiratory Function (SCARF) Score: A Dynamic Prognostic Score for COVID-19. J Assoc Physicians India. 2021;69(1):11-12.
}
\examples{

# Example 1: Low Risk
# RR 18 (0), SpO2 98 (0), 1 Lobe (0)
# Score = 0
scarf_score(18, 98, 1)

# Example 2: High Risk
# RR 26 (4), SpO2 92 (4), 4 Lobes (5)
# Score = 13
scarf_score(26, 92, 4)
}
