\name{abg_analyzer}
\alias{abg_analyzer}
\title{
Arterial Blood Gas (ABG) Analyzer
}
\description{
Interprets arterial blood gas values to identify acid-base disturbances. It determines the primary disorder (Respiratory vs. Metabolic, Acidosis vs. Alkalosis), assesses the degree of compensation (Acute vs. Chronic, or appropriate secondary response), and calculates the Anion Gap and Delta Ratio if electrolytes are provided.
}
\usage{
abg_analyzer(ph, paco2, hco3, na = NULL, cl = NULL, albumin = 4.0)
}
\arguments{
  \item{ph}{
Numeric. Arterial pH.
}
  \item{paco2}{
Numeric. Partial pressure of carbon dioxide (mmHg).
}
  \item{hco3}{
Numeric. Bicarbonate concentration (mEq/L).
}
  \item{na}{
Numeric (Optional). Serum sodium (mEq/L). Required for Anion Gap calculation.
}
  \item{cl}{
Numeric (Optional). Serum chloride (mEq/L). Required for Anion Gap calculation.
}
  \item{albumin}{
Numeric (Optional). Serum albumin (g/dL). Used to correct the Anion Gap. Defaults to 4.0 if not provided.
}
}
\value{
A list containing:
\item{Diagnosis}{The primary acid-base disorder identified.}
\item{Compensation}{Analysis of the compensatory response (e.g., Uncompensated, Compensated, or Mixed).}
\item{Anion_Gap_Analysis}{If electrolytes are provided, reports the Anion Gap (corrected for albumin) and the Delta Ratio interpretation for high gap acidosis.}
}
\references{
Adrogué HJ, Madias NE. Management of life-threatening acid-base disorders. N Engl J Med. 1998;338(1):26-34.
}
\examples{

# Example 1: Diabetic Ketoacidosis (High AG Met Acidosis)
# pH 7.2, pCO2 25 (Compensated), HCO3 10, Na 140, Cl 100
abg_analyzer(7.2, 25, 10, 140, 100)

# Example 2: Acute Respiratory Acidosis (Opioid Overdose)
# pH 7.25, pCO2 60, HCO3 26 (Acute/Uncompensated)
abg_analyzer(7.25, 60, 26)

# Example 3: Mixed Disorder (Septic Shock + Vomiting)
# High AG Acidosis + Met Alkalosis
# pH 7.4, pCO2 40, HCO3 24 (Normal pH/Nos), but High Gap
# Na 140, Cl 90, Alb 4.0
# AG = 140 - (90 + 24) = 26. Delta Gap = 14. Delta HCO3 = 0. Ratio > 2.0
abg_analyzer(7.4, 40, 24, 140, 90)
}
