\name{absolute_neutrophil_count}
\alias{absolute_neutrophil_count}
\title{
Absolute Neutrophil Count (ANC)
}
\description{
Calculates the Absolute Neutrophil Count (ANC), a measure of the number of neutrophil granulocytes (including segmented neutrophils and bands) present in the blood. ANC is critical for assessing the risk of infection in patients undergoing chemotherapy or those with other immune system suppressions.
}
\usage{
absolute_neutrophil_count(wbc, neutrophils_percent, bands_percent = 0)
}
\arguments{
  \item{wbc}{
Numeric. The total White Blood Cell count. Can be entered as cells/microL (e.g., 4500) or k/microL (e.g., 4.5).
}
  \item{neutrophils_percent}{
Numeric. The percentage of segmented neutrophils ("segs" or "polys") from the differential (0-100).
}
  \item{bands_percent}{
Numeric (Optional). The percentage of band neutrophils ("bands") from the differential (0-100). Defaults to 0 if not reported.
}
}
\value{
A list containing:
\item{ANC}{The calculated Absolute Neutrophil Count. The unit scale matches the WBC input (e.g., if WBC is in k/uL, ANC is in k/uL).}
\item{Interpretation}{Risk classification (Normal, Mild, Moderate, or Severe Neutropenia). The function attempts to auto-detect the unit scale for interpretation.}
}
\references{
Al-Gwaiz LA, Babay HH. The diagnostic value of absolute lymphocyte count in typhoid fever. J Infect Dev Ctries. 2007;1(3):260-265. (General hematology reference).
}
\examples{

# Example 1: Severe Neutropenia (Chemotherapy patient)
# WBC 1.2 k/uL, 20\% Segs, 5\% Bands
# ANC = 1.2 * (0.20 + 0.05) = 0.3 k/uL (300 cells/uL)
absolute_neutrophil_count(1.2, 20, 5)

# Example 2: Normal
# WBC 6000 cells/uL, 50\% Segs, 0\% Bands
absolute_neutrophil_count(6000, 50)
}
