\name{acc_aha_hf_staging}
\alias{acc_aha_hf_staging}
\title{
ACC/AHA Heart Failure Staging
}
\description{
Determines the stage of Heart Failure (A, B, C, or D) based on the American College of Cardiology (ACC) and American Heart Association (AHA) guidelines. This classification emphasizes the development and progression of the disease, from patients at risk to those with refractory symptoms.
}
\usage{
acc_aha_hf_staging(risk_factors, structural_disease, hf_symptoms, refractory_hf)
}
\arguments{
  \item{risk_factors}{
Numeric (0 or 1). Patient has risk factors for HF (e.g., hypertension, diabetes, obesity, metabolic syndrome, family history of cardiomyopathy, or use of cardiotoxins) but no structural heart disease or symptoms.
}
  \item{structural_disease}{
Numeric (0 or 1). Patient has structural heart disease (e.g., prior MI, LV remodeling/LVH, low EF, valvular disease) but has never had signs or symptoms of HF.
}
  \item{hf_symptoms}{
Numeric (0 or 1). Patient has structural heart disease with prior or current symptoms of HF (e.g., dyspnea, fatigue, reduced exercise tolerance).
}
  \item{refractory_hf}{
Numeric (0 or 1). Patient has refractory HF requiring specialized interventions (e.g., marked symptoms at rest despite maximal medical therapy).
}
}
\value{
A list containing:
\item{Stage}{The calculated ACC/AHA Stage (A, B, C, or D).}
\item{Description}{Clinical description of the patient's status.}
\item{Management_Guidance}{General therapeutic goals associated with the stage.}
}
\references{
Yancy CW, Jessup M, Bozkurt B, et al. 2013 ACCF/AHA Guideline for the Management of Heart Failure. Circulation. 2013;128(16):e240-e327. doi:10.1161/CIR.0b013e31829e8776
}
\examples{

# Example 1: Stage C (Symptomatic)
# Patient with structural disease and dyspnea
acc_aha_hf_staging(1, 1, 1, 0)

# Example 2: Stage A (At Risk)
# Hypertension only, no structural disease or symptoms
acc_aha_hf_staging(1, 0, 0, 0)
}
