\name{bishop_score_induction}
\alias{bishop_score_induction}
\title{
Bishop Score for Vaginal Delivery / Induction of Labor
}
\description{
Calculates the Bishop Score to assess cervical readiness for induction of labor. The score evaluates five parameters: Dilation, Effacement, Station, Consistency, and Position of the cervix. A higher score indicates a more favorable cervix and a higher likelihood of successful vaginal delivery.
}
\usage{
bishop_score_induction(dilation_cm, effacement_percent, station,
                       consistency, position)
}
\arguments{
  \item{dilation_cm}{
Numeric. Cervical dilation in centimeters.
0 cm: 0 pts.
1-2 cm: 1 pt.
3-4 cm: 2 pts.
>= 5 cm: 3 pts.
}
  \item{effacement_percent}{
Numeric. Cervical effacement percentage.
0-30\%: 0 pts.
40-50\%: 1 pt.
60-70\%: 2 pts.
>= 80\%: 3 pts.
}
  \item{station}{
Numeric. Fetal station relative to ischial spines (-3 to +2).
-3: 0 pts.
-2: 1 pt.
-1, 0: 2 pts.
+1, +2: 3 pts.
}
  \item{consistency}{
String. Consistency of the cervix. Options: "firm" (0 pts), "medium" (1 pt), "soft" (2 pts).
}
  \item{position}{
String. Position of the cervix. Options: "posterior" (0 pts), "midposition" (1 pt), "anterior" (2 pts).
}
}
\value{
A list containing:
\item{Bishop_Score}{The calculated total score (Range 0-13).}
\item{Interpretation}{Clinical assessment of inducibility (Favorable > 8, Unfavorable < 6).}
}
\references{
Bishop EH. Pelvic scoring for elective induction. Obstet Gynecol. 1964;24:266-268.
}
\examples{

# Example 1: Unfavorable Cervix
# Closed, 30\% effaced, -3 station, Firm, Posterior
# Score = 0
bishop_score_induction(0, 30, -3, "firm", "posterior")

# Example 2: Favorable Cervix
# 4cm dilated (2), 60\% effaced (2), -1 station (2), Soft (2), Anterior (2)
# Score = 10
bishop_score_induction(4, 60, -1, "soft", "anterior")
}
