\name{body_mass_index_bsa}
\alias{body_mass_index_bsa}
\title{
Body Mass Index (BMI) and Body Surface Area (BSA)
}
\description{
Calculates the Body Mass Index (BMI) and estimates Body Surface Area (BSA) using five common formulas (Mosteller, Du Bois, Haycock, Gehan-George, and Boyd). These metrics are fundamental for dosing medications (e.g., chemotherapy), assessing nutritional status, and stratifying obesity risks.
}
\usage{
body_mass_index_bsa(weight_kg, height_cm)
}
\arguments{
  \item{weight_kg}{
Numeric. Patient weight in kilograms.
}
  \item{height_cm}{
Numeric. Patient height in centimeters.
}
}
\value{
A list containing:
\item{BMI_kg_m2}{Calculated BMI (Weight / Height^2).}
\item{BMI_Category}{Classification based on WHO guidelines (Underweight, Normal, Overweight, Obesity Class I-III).}
\item{BSA_Mosteller_m2}{BSA calculated using the Mosteller formula (Standard for many applications).}
\item{BSA_DuBois_m2}{BSA calculated using the Du Bois & Du Bois formula.}
\item{BSA_Haycock_m2}{BSA calculated using the Haycock formula (Often preferred in pediatrics).}
\item{BSA_Gehan_George_m2}{BSA calculated using the Gehan-George formula.}
\item{BSA_Boyd_m2}{BSA calculated using the Boyd formula.}
}
\references{
Mosteller RD. Simplified calculation of body-surface area. N Engl J Med. 1987;317(17):1098. doi:10.1056/NEJM198710223171717

Du Bois D, Du Bois EF. A formula to estimate the approximate surface area if height and weight be known. Arch Intern Med. 1916;17(6):863-871.
}
\examples{

# Example 1: Average Adult
# 75 kg, 175 cm
body_mass_index_bsa(75, 175)

# Example 2: Child
# 30 kg, 130 cm
body_mass_index_bsa(30, 130)
}
