\name{body_roundness_index}
\alias{body_roundness_index}
\title{
Body Roundness Index (BRI)
}
\description{
Calculates the Body Roundness Index (BRI), a geometric measure of body composition that models the human body as an ellipse. BRI improves upon Body Mass Index (BMI) by quantifying the degree of central adiposity (visceral fat), which is a stronger predictor of metabolic syndrome, cardiovascular disease, and all-cause mortality.
}
\usage{
body_roundness_index(waist_cm, height_cm)
}
\arguments{
  \item{waist_cm}{
Numeric. Waist circumference in centimeters.
}
  \item{height_cm}{
Numeric. Height in centimeters.
}
}
\value{
A list containing:
\item{BRI_Score}{The calculated Body Roundness Index. Scores range from 1 to roughly 20. Higher scores indicate greater central adiposity and a rounder body shape.}
}
\references{
Thomas DM, Bredlau C, Bosy-Westphal A, et al. Relationships between body roundness with body fat and visceral adipose tissue emerging from a new geometric model. Obesity (Silver Spring). 2013;21(11):2264-2271. doi:10.1002/oby.20408
}
\examples{

# Example 1: Average measurements
# Waist 85 cm, Height 175 cm
body_roundness_index(85, 175)

# Example 2: High central adiposity
# Waist 110 cm, Height 170 cm
body_roundness_index(110, 170)
}
