\name{bps_intubated_pain}
\alias{bps_intubated_pain}
\title{
Behavioral Pain Scale (BPS) for Intubated Patients
}
\description{
Calculates the Behavioral Pain Scale (BPS) score to assess pain in unconscious, sedated, and intubated patients. The scale evaluates three behavioral domains: Facial Expression, Upper Limb Movements, and Compliance with Mechanical Ventilation.
}
\usage{
bps_intubated_pain(facial_expression, upper_limb_movements, compliance_ventilation)
}
\arguments{
  \item{facial_expression}{
Numeric (1-4).
1: Relaxed.
2: Partially tightened (e.g., brow lowering).
3: Fully tightened (e.g., eyelid closing).
4: Grimacing.
}
  \item{upper_limb_movements}{
Numeric (1-4).
1: No movement.
2: Partially bent.
3: Fully bent with finger flexion.
4: Permanently retracted.
}
  \item{compliance_ventilation}{
Numeric (1-4).
1: Tolerating movement.
2: Coughing but tolerating ventilation most of the time.
3: Fighting ventilator.
4: Unable to control ventilation.
}
}
\value{
A list containing:
\item{BPS_Score}{The sum of the three domain scores (Range 3-12).}
\item{Interpretation}{Clinical guidance. A score > 5 generally indicates significant pain requiring intervention.}
}
\references{
Payen JF, Bru O, Bosson JL, et al. Assessing pain in critically ill sedated patients by using a behavioral pain scale. Crit Care Med. 2001;29(12):2258-2263. doi:10.1097/00003246-200112000-00004
}
\examples{

# Example 1: Significant Pain
# Grimacing (4), Fully bent arms (3), Fighting vent (3)
# Score = 10
bps_intubated_pain(4, 3, 3)

# Example 2: No Pain
# Relaxed (1), No movement (1), Tolerating vent (1)
# Score = 3
bps_intubated_pain(1, 1, 1)
}
