\name{brue_2_0_criteria}
\alias{brue_2_0_criteria}
\title{
Brief Resolved Unexplained Events 2.0 (BRUE 2.0) Criteria
}
\description{
Applies the BRUE 2.0 criteria (based on the 2016 AAP Guidelines and subsequent validation) to risk-stratify infants presenting with a Brief Resolved Unexplained Event. The tool identifies "Lower-Risk" infants who require minimal workup versus "Higher-Risk" infants who may benefit from further observation or diagnostic testing. A BRUE is defined as a sudden, brief, resolved episode of cyanosis/pallor, absent/irregular breathing, marked tone change, or altered responsiveness in an infant < 1 year, with no explanation after history and physical exam.
}
\usage{
brue_2_0_criteria(age_days, gestational_age_weeks, duration_less_than_1_min,
                  cpr_performed, recurring_event, concerning_history,
                  concerning_exam)
}
\arguments{
  \item{age_days}{
Numeric. Chronological age of the infant in days.
}
  \item{gestational_age_weeks}{
Numeric. Gestational age at birth in weeks.
}
  \item{duration_less_than_1_min}{
Numeric (0 or 1). Was the duration of the event < 1 minute? (1 = Yes).
}
  \item{cpr_performed}{
Numeric (0 or 1). Was CPR performed by a trained medical provider? (1 = Yes).
}
  \item{recurring_event}{
Numeric (0 or 1). Was this a recurring event (not the first episode) or part of a cluster? (1 = Yes).
}
  \item{concerning_history}{
Numeric (0 or 1). Are there concerning features in the history (e.g., family history of sudden death, social concerns)? (1 = Yes).
}
  \item{concerning_exam}{
Numeric (0 or 1). Are there concerning findings on physical examination (e.g., injury, growth failure)? (1 = Yes).
}
}
\value{
A list containing:
\item{Classification}{"Lower-Risk BRUE", "Higher-Risk BRUE", or "Not BRUE".}
\item{Management_Guidance}{Clinical recommendations derived from AAP 2016 guidelines.}
\item{Risk_Factors_Present}{A list of specific criteria that placed the patient in the Higher-Risk category.}
}
\references{
Tieder JS, Bonkowsky JL, Etzel RA, et al. Clinical Practice Guideline: Brief Resolved Unexplained Events (Formerly Apparent Life-Threatening Events) and Evaluation of Lower-Risk Infants. Pediatrics. 2016;138(1):e20160590. doi:10.1542/peds.2016-0590
}
\examples{

# Example 1: Lower-Risk BRUE
# 4-month-old (120d), term (40w), brief event, no CPR, first time, normal H&P
brue_2_0_criteria(120, 40, 1, 0, 0, 0, 0)

# Example 2: Higher-Risk BRUE (Age)
# 45-day-old, otherwise low risk
brue_2_0_criteria(45, 40, 1, 0, 0, 0, 0)

# Example 3: Higher-Risk BRUE (Duration & Recurrence)
# 3-month-old, event > 1 min, recurring
brue_2_0_criteria(90, 39, 0, 0, 1, 0, 0)
}
