\name{calcium_correction_hypoalbuminemia}
\alias{calcium_correction_hypoalbuminemia}
\title{
Calcium Correction for Hypoalbuminemia (Payne's Formula)
}
\description{
Calculates the corrected serum calcium level in patients with hypoalbuminemia. Since approximately 40-45\% of serum calcium is bound to albumin, low albumin levels can result in a falsely low total serum calcium reading despite normal ionized calcium levels. The formula adjusts the total calcium to estimate what the level would be if albumin were normal (4.0 g/dL).
}
\usage{
calcium_correction_hypoalbuminemia(calcium, albumin,
                                   calcium_units = "mg/dL",
                                   albumin_units = "g/dL")
}
\arguments{
  \item{calcium}{
Numeric. The measured total serum calcium level.
}
  \item{albumin}{
Numeric. The measured serum albumin level.
}
  \item{calcium_units}{
String. Units for the calcium input. Options: "mg/dL" (default) or "mmol/L".
}
  \item{albumin_units}{
String. Units for the albumin input. Options: "g/dL" (default) or "g/L".
}
}
\value{
A list containing:
\item{Corrected_Calcium_mg_dL}{The estimated corrected calcium in mg/dL.}
\item{Corrected_Calcium_mmol_L}{The estimated corrected calcium in mmol/L.}
}
\references{
Payne RB, Little AJ, Williams RB, Milner JR. Interpretation of serum calcium in patients with abnormal serum proteins. Br Med J. 1973;4(5893):643-646. doi:10.1136/bmj.4.5893.643
}
\examples{

# Example 1: Hypoalbuminemia masking hypercalcemia
# Calcium 10.5 mg/dL (High normal), Albumin 2.5 g/dL (Low)
# Corrected = 10.5 + 0.8 * (4.0 - 2.5) = 11.7 (Hypercalcemia)
calcium_correction_hypoalbuminemia(10.5, 2.5)

# Example 2: SI Units
# Calcium 2.2 mmol/L, Albumin 30 g/L
calcium_correction_hypoalbuminemia(2.2, 30, "mmol/L", "g/L")
}
