\name{car_olt_score}
\alias{car_olt_score}
\title{
Cardiovascular Risk in Orthotopic Liver Transplantation (CAR-OLT)
}
\description{
Structures the inputs for the CAR-OLT risk score, a tool designed to predict the 1-year risk of major adverse cardiovascular events (MACE) following orthotopic liver transplantation. The score uses 12 pre-transplant characteristics to stratify candidates, helping to identify those who may require further cardiac testing versus those (Low Risk, score <= 23) who may proceed safely.
}
\usage{
car_olt_score(age, sex, race, employment_status, education_level,
              history_hcc, diabetes, heart_failure, atrial_fibrillation,
              pulmonary_hypertension, systemic_hypertension, respiratory_failure)
}
\arguments{
  \item{age}{
Numeric. Recipient age in years.
}
  \item{sex}{
String. "Male" or "Female".
}
  \item{race}{
String. Recipient race (e.g., "White", "Black", "Other").
}
  \item{employment_status}{
String. "Working" or "Not Working".
}
  \item{education_level}{
String. "College" or "High School or Less".
}
  \item{history_hcc}{
Numeric (0 or 1). History of Hepatocellular Carcinoma. (1 = Yes).
}
  \item{diabetes}{
Numeric (0 or 1). History of Diabetes Mellitus. (1 = Yes).
}
  \item{heart_failure}{
Numeric (0 or 1). History of Heart Failure. (1 = Yes).
}
  \item{atrial_fibrillation}{
Numeric (0 or 1). History of Atrial Fibrillation. (1 = Yes).
}
  \item{pulmonary_hypertension}{
Numeric (0 or 1). History of Pulmonary Hypertension. (1 = Yes).
}
  \item{systemic_hypertension}{
Numeric (0 or 1). History of Systemic Hypertension. (1 = Yes).
}
  \item{respiratory_failure}{
Numeric (0 or 1). Respiratory failure (on ventilator) at time of transplant. (1 = Yes).
}
}
\value{
A list containing:
\item{Inputs}{The formatted list of patient risk factors.}
\item{Risk_Threshold}{Interpretation based on the published low-risk cutoff (<= 23).}
}
\references{
VanWagner LB, Ning H, Whitsett M, et al. A point-based prediction model for cardiovascular risk in orthotopic liver transplantation: The CAR-OLT score. Hepatology. 2017;66(6):1968-1979. doi:10.1002/hep.29329
}
\examples{

# Example: Patient structure
car_olt_score(55, "male", "white", "working", "college", 0, 1, 0, 0, 0, 1, 0)
}
