\name{circ_covid_risk}
\alias{circ_covid_risk}
\title{
COVID-19 Inpatient Risk Calculator (CIRC)
}
\description{
Calculates the CIRC score to estimate the probability of death within 7 days of hospital admission for patients with COVID-19. Developed by Johns Hopkins researchers, this model uses patient demographics, comorbidities (Charlson Index), and admission vital signs to stratify mortality risk.
}
\usage{
circ_covid_risk(age, race_black, nursing_home_resident, charlson_score, bmi,
                temp_c, respiratory_rate, heart_rate, spo2, sbp)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
}
  \item{race_black}{
Numeric (0 or 1). Is the patient Black/African American? (1 = Yes). (Included as a variable in the original derivation model).
}
  \item{nursing_home_resident}{
Numeric (0 or 1). Was the patient admitted from a nursing home or assisted living facility? (1 = Yes).
}
  \item{charlson_score}{
Numeric. The patient's Charlson Comorbidity Index (CCI) score.
}
  \item{bmi}{
Numeric. Body Mass Index in kg/m^2.
}
  \item{temp_c}{
Numeric. Admission temperature in degrees Celsius.
}
  \item{respiratory_rate}{
Numeric. Admission respiratory rate in breaths/min.
}
  \item{heart_rate}{
Numeric. Admission heart rate in bpm.
}
  \item{spo2}{
Numeric. Admission oxygen saturation (\%) on room air or O2.
}
  \item{sbp}{
Numeric. Admission Systolic Blood Pressure in mmHg.
}
}
\value{
A list containing:
\item{Est_Mortality_Risk_7_Day}{Estimated percentage probability of mortality within 7 days.}
\item{Risk_Category}{General risk classification (Low, Moderate, High).}
}
\references{
Garibaldi BT, Fiksel J, Muschelli J, et al. Patient Trajectories Among Persons Hospitalized for COVID-19: A Cohort Study. Ann Intern Med. 2021;174(1):33-41. doi:10.7326/M20-3905
}
\examples{

# Example 1: High Risk
# 80yo, Nursing Home, CCI 6, Hypoxic (88\%), Tachypneic
circ_covid_risk(80, 0, 1, 6, 24, 37.5, 30, 110, 88, 110)

# Example 2: Low Risk
# 40yo, Home, CCI 0, Normal vitals
circ_covid_risk(40, 0, 0, 0, 22, 36.8, 14, 70, 98, 120)
}
