\name{coronavirus_anxiety_scale}
\alias{coronavirus_anxiety_scale}
\title{
Coronavirus Anxiety Scale (CAS)
}
\description{
Calculates the Coronavirus Anxiety Scale (CAS) score, a 5-item mental health screener designed to identify probable cases of dysfunctional anxiety associated with the COVID-19 crisis. The scale focuses on the physiological manifestations of anxiety over the past 2 weeks.
}
\usage{
coronavirus_anxiety_scale(dizziness, sleep_disturbance, paralyzed_frozen,
                          appetite_loss, nausea_stomach_pain)
}
\arguments{
  \item{dizziness}{
Numeric (0-4). Frequency of feeling dizzy, lightheaded, or faint when reading/listening to news about the coronavirus.
}
  \item{sleep_disturbance}{
Numeric (0-4). Frequency of trouble falling or staying asleep because of thinking about the coronavirus.
}
  \item{paralyzed_frozen}{
Numeric (0-4). Frequency of feeling paralyzed or frozen when thinking about or exposed to information about the coronavirus.
}
  \item{appetite_loss}{
Numeric (0-4). Frequency of losing interest in eating when thinking about or exposed to information about the coronavirus.
}
  \item{nausea_stomach_pain}{
Numeric (0-4). Frequency of feeling nauseous or having stomach problems when thinking about or exposed to information about the coronavirus.
}
}
\details{
\strong{Scoring Key (Frequency over last 2 weeks):}
0 = Not at all.
1 = Rare, less than a day or two.
2 = Several days.
3 = More than 7 days.
4 = Nearly every day over the last 2 weeks.
}
\value{
A list containing:
\item{CAS_Score}{The calculated total score (Range 0-20).}
\item{Result}{"Positive Screen" (Score >= 9) or "Negative Screen".}
\item{Interpretation}{Clinical context regarding dysfunctional anxiety.}
}
\references{
Lee SA. Coronavirus Anxiety Scale: A brief mental health screener for COVID-19 related anxiety. Death Stud. 2020;44(7):393-401. doi:10.1080/07481187.2020.1748481
}
\examples{

# Example 1: High Anxiety
# Dizziness (2), Sleep (3), Frozen (2), Appetite (1), Nausea (2)
# Score = 10 (Positive)
coronavirus_anxiety_scale(2, 3, 2, 1, 2)

# Example 2: Low Anxiety
# Sleep disturbance only (2), all others 0
# Score = 2 (Negative)
coronavirus_anxiety_scale(0, 2, 0, 0, 0)
}
