\name{digifab_dosing}
\alias{digifab_dosing}
\title{
DigiFab Dosing for Digoxin Poisoning
}
\description{
Calculates the recommended number of DigiFab (Digoxin Immune Fab) vials for the treatment of digoxin toxicity. The calculator prioritizes dosing based on serum digoxin concentration, followed by the amount ingested (for acute cases), and finally defaults to empiric dosing guidelines if neither is known.
}
\usage{
digifab_dosing(poisoning_type, weight_kg, digoxin_level_ng_ml = NULL,
               amount_ingested_mg = NULL)
}
\arguments{
  \item{poisoning_type}{
String. "acute" or "chronic".
}
  \item{weight_kg}{
Numeric. Patient weight in kilograms.
}
  \item{digoxin_level_ng_ml}{
Numeric (Optional). Serum digoxin concentration in ng/mL. This is the preferred method for calculation.
}
  \item{amount_ingested_mg}{
Numeric (Optional). Estimated amount of digoxin ingested in milligrams. Used for acute cases if serum level is unknown.
}
}
\value{
A list containing:
\item{Recommended_Vials}{The calculated number of vials (rounded up to the nearest whole number).}
\item{Total_Dose_mg}{The total dose in milligrams (40 mg per vial).}
\item{Calculation_Method}{The method used to determine the dose (Serum Level, Amount Ingested, or Empiric).}
}
\references{
DigiFab [package insert]. King of Prussia, PA: BTG International Inc; 2017.
Antman EM, Wenger TL, Butler VP Jr, Haber E, Smith TW. Treatment of 150 cases of life-threatening digitalis intoxication with digoxin-specific Fab antibody fragments. Final report of a multicenter study. Circulation. 1990;81(6):1744-1752.
}
\examples{

# Example 1: Known Serum Level
# Chronic toxicity, 70kg, Level 4.0 ng/mL
# Dose = (4 * 70) / 100 = 2.8 -> 3 vials
digifab_dosing("chronic", 70, digoxin_level_ng_ml = 4.0)

# Example 2: Acute Ingestion (Unknown Level)
# Acute, 60kg, Ingested 10 mg
# Dose = 10 * 1.6 = 16 vials
digifab_dosing("acute", 60, amount_ingested_mg = 10)

# Example 3: Empiric Acute
# Acute, 80kg, Unknown details
# Dose = 10 vials (Empiric)
digifab_dosing("acute", 80)
}
