\name{dli_volume_calculator}
\alias{dli_volume_calculator}
\title{
Donor Lymphocyte Infusion (DLI) Volume Calculator
}
\description{
Estimates the volume of whole blood to process via apheresis to collect the required number of CD3+ cells for Donor Lymphocyte Infusion (DLI). The calculation accounts for recipient weight, target dose per infusion, number of infusions, donor blood parameters, and machine collection efficiency.
}
\usage{
dli_volume_calculator(recipient_weight_kg, target_cd3_dose_per_kg,
                      donor_wbc_count_cells_ul, donor_lymphocyte_percent,
                      donor_cd3_percent, collection_efficiency_percent,
                      num_infusions)
}
\arguments{
  \item{recipient_weight_kg}{
Numeric. Recipient's weight in kilograms.
}
  \item{target_cd3_dose_per_kg}{
Numeric. The target dose of CD3+ cells per kg (e.g., 1e7).
}
  \item{donor_wbc_count_cells_ul}{
Numeric. Donor's White Blood Cell count in cells/uL (e.g., 6000).
}
  \item{donor_lymphocyte_percent}{
Numeric. Percentage of lymphocytes in the donor's WBC differential (0-100).
}
  \item{donor_cd3_percent}{
Numeric. Percentage of CD3+ cells within the lymphocyte population (0-100).
}
  \item{collection_efficiency_percent}{
Numeric. The efficiency of the apheresis machine in collecting lymphocytes (typically 40-60\%).
}
  \item{num_infusions}{
Numeric. The total number of DLI doses planned for the recipient.
}
}
\value{
A list containing:
\item{Volume_to_Process_L}{The estimated volume of donor blood to process in Liters.}
\item{Total_CD3_Cells_Required}{The total absolute count of CD3+ cells needed.}
\item{Donor_CD3_Concentration_cells_mL}{The calculated concentration of CD3+ cells in the donor's blood.}
}
\references{
Guidelines on the Use of Therapeutic Apheresis in Clinical Practice. J Clin Apher. 2019.
}
\examples{

# Example 1: Standard Collection
# 70kg Recipient, Target 1x10^7 cells/kg, 1 Dose
# Donor: WBC 6000/uL, Lymphs 30\%, CD3 70\%, Efficiency 50\%
dli_volume_calculator(70, 1e7, 6000, 30, 70, 50, 1)

# Example 2: Multiple Doses
# Same patient, but 3 doses planned
dli_volume_calculator(70, 1e7, 6000, 30, 70, 50, 3)
}
