\name{duke_treadmill_score}
\alias{duke_treadmill_score}
\title{
Duke Treadmill Score
}
\description{
Calculates the Duke Treadmill Score (DTS), a widely used prognostic tool for patients undergoing exercise treadmill testing. The score predicts 5-year mortality and stratifies patients into low, moderate, and high-risk categories based on exercise capacity, ST-segment deviation, and exercise-induced angina.
}
\usage{
duke_treadmill_score(exercise_time_min, max_st_depression_mm, angina_index)
}
\arguments{
  \item{exercise_time_min}{
Numeric. Total exercise time in minutes using the Bruce protocol.
}
  \item{max_st_depression_mm}{
Numeric. Maximum net ST-segment deviation (depression or elevation) in millimeters during or after exercise (relative to baseline).
}
  \item{angina_index}{
Numeric (0, 1, or 2). Exercise-induced angina.
0: No angina.
1: Non-limiting angina (occurred but test continued).
2: Limiting angina (test stopped due to angina).
}
}
\value{
A list containing:
\item{Duke_Score}{The calculated DTS score (Range typically -25 to +15).}
\item{Risk_Group}{Classification (Low >= +5, Moderate -10 to +4, High < -10).}
\item{Annual_Mortality_Risk}{Estimated annual mortality rate.}
\item{Five_Year_Survival}{Estimated 5-year survival rate.}
}
\references{
Mark DB, Hlatky MA, Harrell FE Jr, et al. Exercise treadmill score for predicting prognosis in coronary artery disease. Ann Intern Med. 1987;106(6):793-800. doi:10.7326/0003-4819-106-6-793
}
\examples{

# Example 1: Low Risk
# 10 minutes exercise, 0mm ST depression, No Angina
# Score = 10 - 0 - 0 = 10
duke_treadmill_score(10, 0, 0)

# Example 2: High Risk
# 3 minutes exercise, 2mm ST depression, Limiting Angina
# Score = 3 - (5*2) - (4*2) = 3 - 10 - 8 = -15
duke_treadmill_score(3, 2, 2)
}
