\name{figo_ovarian_cancer_staging}
\alias{figo_ovarian_cancer_staging}
\title{
FIGO Staging for Ovarian Cancer (2014)
}
\description{
Determines the 2014 FIGO Stage for Ovarian, Fallopian Tube, and Peritoneal Cancer based on surgical and pathological findings.
}
\usage{
figo_ovarian_cancer_staging(tumor_location, capsule_rupture, surface_involvement,
                            ascites_cytology, pelvic_extension, abdominal_extension,
                            lymph_node_involvement, distant_metastasis)
}
\arguments{
  \item{tumor_location}{
String. "one_ovary", "both_ovaries", "none".
}
  \item{capsule_rupture}{
Numeric (0 or 1). Capsule ruptured (surgical or spontaneous).
}
  \item{surface_involvement}{
Numeric (0 or 1). Tumor present on ovarian/fallopian tube surface.
}
  \item{ascites_cytology}{
Numeric (0 or 1). Malignant cells in ascites or peritoneal washings.
}
  \item{pelvic_extension}{
String. "none", "uterus_tubes", "other_pelvic_tissues".
}
  \item{abdominal_extension}{
String. "none", "microscopic" (extrapelvic), "macroscopic_lt_2cm", "macroscopic_gt_2cm". (Includes liver/spleen capsule involvement).
}
  \item{lymph_node_involvement}{
String. "none", "retroperitoneal_lt_10mm", "retroperitoneal_gt_10mm".
}
  \item{distant_metastasis}{
String. "none", "pleural_effusion" (positive cytology), "parenchymal" (liver/spleen parenchyma), "extra_abdominal" (other organs/inguinal nodes).
}
}
\value{
A list containing:
\item{FIGO_Stage}{The calculated stage (I-IV with substages).}
\item{Description}{The clinical definition of the stage.}
}
\references{
Prat J; FIGO Committee on Gynecologic Oncology. Staging classification for cancer of the ovary, fallopian tube, and peritoneum. Int J Gynaecol Obstet. 2014;124(1):1-5. doi:10.1016/j.ijgo.2013.10.001
}
\examples{

# Example 1: Stage IA
figo_ovarian_cancer_staging("one_ovary", 0, 0, 0, "none", "none", "none", "none")

# Example 2: Stage IIIC (Macroscopic abdominal mets > 2cm)
figo_ovarian_cancer_staging("both_ovaries", 1, 1, 1, "uterus_tubes",
"macroscopic_gt_2cm", "retroperitoneal_gt_10mm", "none")
}
