\name{gail_model_risk}
\alias{gail_model_risk}
\title{
Gail Model for Breast Cancer Risk Assessment (BCRAT)
}
\description{
Calculates the Relative Risk (RR) of developing invasive breast cancer using the Gail Model algorithm (NCI BCRAT). This function computes the composite risk factor based on age, menarche, reproductive history, family history, and biopsy history. Note: The absolute 5-year and lifetime percentage risks require integration with large actuarial baseline hazard tables which are not embedded here; this function provides the core relative risk multiplier.
}
\usage{
gail_model_risk(age, age_menarche, age_first_live_birth,
                num_first_degree_relatives, num_biopsies,
                atypical_hyperplasia, race = "white")
}
\arguments{
  \item{age}{
Numeric. Current patient age in years (valid 35+).
}
  \item{age_menarche}{
Numeric. Age at onset of first menstrual period.
}
  \item{age_first_live_birth}{
Numeric. Age at time of first live birth. Use 0 if nulliparous.
}
  \item{num_first_degree_relatives}{
Numeric. Number of first-degree relatives (mother, sisters, daughters) with breast cancer.
}
  \item{num_biopsies}{
Numeric. Number of previous breast biopsies (0, 1, or 2 for >=2).
}
  \item{atypical_hyperplasia}{
Numeric (0 or 1). History of atypical hyperplasia in biopsies. (1 = Yes, 0 = No, or unknown). Applicable only if num_biopsies > 0.
}
  \item{race}{
String. Patient race/ethnicity (e.g., "white"). Note: This implementation uses coefficients standard for White females (Gail Model 2); relative risk weights may vary slightly for other populations in the full NCI tool.
}
}
\value{
A list containing:
\item{Relative_Risk}{The calculated relative risk score compared to a woman of the same age with no risk factors (RR=1.0).}
\item{Interpretation}{Context regarding the conversion of RR to absolute probability.}
}
\references{
Gail MH, Brinton LA, Byar DP, et al. Projecting individualized probabilities of developing breast cancer for white females who are being examined annually. J Natl Cancer Inst. 1989;81(24):1879-1886. doi:10.1093/jnci/81.24.1879
Costantino JP, Gail MH, Pee D, et al. Validation studies for models projecting the risk of invasive and total breast cancer incidence. J Natl Cancer Inst. 1999;91(18):1541-1548.
}
\examples{

# Example 1: High Risk
# 55yo, Menarche 11, 1st Birth 30, 2 Relatives, 1 Biopsy (w/ Hyperplasia)
gail_model_risk(55, 11, 30, 2, 1, 1)

# Example 2: Low Risk
# 40yo, Menarche 14, 1st Birth 22, 0 Relatives, 0 Biopsies
gail_model_risk(40, 14, 22, 0, 0, 0)
}
