\name{glucose_infusion_rate}
\alias{glucose_infusion_rate}
\title{
Glucose Infusion Rate (GIR) Calculator
}
\description{
Calculates the Glucose Infusion Rate (GIR) in mg/kg/min. This calculation is essential in neonatal and pediatric care to ensure adequate glucose delivery for metabolic needs while preventing hypoglycemia or hyperglycemia.
}
\usage{
glucose_infusion_rate(iv_rate_ml_hr, dextrose_conc_percent, weight_kg)
}
\arguments{
  \item{iv_rate_ml_hr}{
Numeric. The rate of intravenous fluid administration in mL per hour.
}
  \item{dextrose_conc_percent}{
Numeric. The concentration of dextrose in the fluid (e.g., 10 for D10W, 5 for D5W).
}
  \item{weight_kg}{
Numeric. The patient's weight in kilograms.
}
}
\value{
A list containing:
\item{GIR_mg_kg_min}{The calculated glucose infusion rate.}
\item{Interpretation}{General clinical context regarding standard maintenance ranges (typically 4-6 mg/kg/min for neonates).}
}
\references{
Adamkin DH. Nutrition management of the very low-birthweight infant. NeoReviews. 2006;7(12):e602-e614.
}
\examples{

# Example 1: Normal Maintenance
# 3 kg neonate, D10W running at 9 mL/hr
# GIR = (9 * 10) / (6 * 3) = 90 / 18 = 5.0 mg/kg/min
glucose_infusion_rate(9, 10, 3)

# Example 2: High Requirement
# 4 kg infant, D12.5W running at 15 mL/hr
# GIR = (15 * 12.5) / (6 * 4) = 187.5 / 24 = 7.81 mg/kg/min
glucose_infusion_rate(15, 12.5, 4)
}
