\name{hacor_score}
\alias{hacor_score}
\title{
HACOR Score for NIV Failure
}
\description{
Calculates the HACOR score to predict the likelihood of Non-Invasive Ventilation (NIV) failure in patients with hypoxemic respiratory failure. The score is based on Heart rate, Acidosis (pH), Consciousness (GCS), Oxygenation (PaO2/FiO2), and Respiratory rate. A score > 5 assessed 1 hour after initiation suggests a high risk of failure.
}
\usage{
hacor_score(heart_rate, ph, gcs, pao2_fio2_ratio, respiratory_rate)
}
\arguments{
  \item{heart_rate}{
Numeric. Heart rate in beats per minute. (>= 120 adds 1 point).
}
  \item{ph}{
Numeric. Arterial pH. (<7.25: 4 pts; 7.25-7.29: 3 pts; 7.30-7.34: 2 pts).
}
  \item{gcs}{
Numeric. Glasgow Coma Scale score. (<15 adds 10 points).
}
  \item{pao2_fio2_ratio}{
Numeric. PaO2/FiO2 ratio. (<=100: 6 pts; 101-125: 5 pts; 126-150: 4 pts; 151-175: 3 pts; 176-200: 2 pts).
}
  \item{respiratory_rate}{
Numeric. Respiratory rate in breaths per minute. (>45: 4 pts; 41-45: 3 pts; 36-40: 2 pts; 31-35: 1 pt).
}
}
\value{
A list containing:
\item{HACOR_Score}{The calculated score (Range 0-25).}
\item{NIV_Failure_Probability}{Estimated probability of NIV failure.}
\item{Recommendation}{Clinical suggestion regarding intubation.}
}
\references{
Duan J, Han X, Bai L, et al. Assessment of heart rate, acidosis, consciousness, oxygenation, and respiratory rate to predict noninvasive ventilation failure in hypoxemic patients. Intensive Care Med. 2017;43(2):192-199. doi:10.1007/s00134-016-4601-3
}
\examples{

# Example 1: High Risk
# HR 130 (+1), pH 7.20 (+4), GCS 14 (+10), PF 120 (+5), RR 35 (+1)
# Score = 21
hacor_score(130, 7.20, 14, 120, 35)

# Example 2: Low Risk
# HR 90 (0), pH 7.40 (0), GCS 15 (0), PF 250 (0), RR 20 (0)
# Score = 0
hacor_score(90, 7.40, 15, 250, 20)
}
