\name{hcm_risk_scd}
\alias{hcm_risk_scd}
\title{
HCM Risk-SCD Calculator
}
\description{
Calculates the 5-year risk of Sudden Cardiac Death (SCD) in patients with Hypertrophic Cardiomyopathy (HCM). The score is used to guide decisions regarding Implantable Cardioverter Defibrillator (ICD) placement. It predicts risk based on age, maximal wall thickness, left atrial size, max LVOT gradient, family history of SCD, non-sustained VT, and unexplained syncope.
}
\usage{
hcm_risk_scd(age, max_wall_thickness_mm, la_diameter_mm, max_lvot_gradient_mmhg,
             family_history_scd, nsvt, unexplained_syncope)
}
\arguments{
  \item{age}{
Numeric. Patient age in years (Validated for 16-115).
}
  \item{max_wall_thickness_mm}{
Numeric. Maximal Left Ventricular wall thickness in mm. (Note: The algorithm caps the risk impact at 35mm).
}
  \item{la_diameter_mm}{
Numeric. Left Atrial diameter in mm (M-mode/2D PLAX).
}
  \item{max_lvot_gradient_mmhg}{
Numeric. Maximal Left Ventricular Outflow Tract gradient in mmHg (at rest or with Valsalva provocation).
}
  \item{family_history_scd}{
Numeric (0 or 1). History of Sudden Cardiac Death in >= 1 first-degree relative < 40 years old or with confirmed HCM. (1 = Yes).
}
  \item{nsvt}{
Numeric (0 or 1). Non-sustained Ventricular Tachycardia (>= 3 consecutive ventricular beats at >= 120 bpm, < 30s duration) on monitoring. (1 = Yes).
}
  \item{unexplained_syncope}{
Numeric (0 or 1). History of unexplained syncope (unrelated to neurocardiogenic causes). (1 = Yes).
}
}
\value{
A list containing:
\item{Risk_SCD_5_Year}{The estimated percentage risk of sudden cardiac death over 5 years.}
\item{Risk_Category}{Classification (Low <4\%, Intermediate 4-6\%, High >=6\%).}
\item{Recommendation}{Clinical guidance regarding ICD implantation according to ESC guidelines.}
}
\references{
O'Mahony C, Jichi F, Pavlou M, et al. A novel clinical risk prediction model for sudden cardiac death in hypertrophic cardiomyopathy (HCM Risk-SCD). Eur Heart J. 2014;35(30):2010-2020. doi:10.1093/eurheartj/eht439
}
\examples{

# Example 1: High Risk
# 45yo, 25mm wall, 45mm LA, 80 mmHg grad, NSVT present
hcm_risk_scd(45, 25, 45, 80, 0, 1, 0)

# Example 2: Low Risk
# 60yo, 18mm wall, 40mm LA, 10 mmHg grad, No other risks
hcm_risk_scd(60, 18, 40, 10, 0, 0, 0)
}
