\name{hepatic_encephalopathy_grade}
\alias{hepatic_encephalopathy_grade}
\title{
West Haven Criteria for Hepatic Encephalopathy Grades
}
\description{
Calculates the West Haven grade for Hepatic Encephalopathy (HE). The grading is determined by the most severe symptom present across four categories: consciousness, intellectual function, behavior, and neuromuscular abnormalities.
}
\usage{
hepatic_encephalopathy_grade(consciousness, intellect, behavior, neuromuscular)
}
\arguments{
  \item{consciousness}{
Numeric (0-4). Level of consciousness.
0: Normal.
1: Mild lack of awareness, sleep disturbance.
2: Lethargic, disoriented to time.
3: Somnolent, semi-stupor.
4: Coma.
}
  \item{intellect}{
Numeric (0-4). Intellectual function.
0: Normal.
1: Shortened attention span, impaired addition/subtraction.
2: Disoriented to time, obvious personality change.
3: Gross disorientation.
4: Unable to test (Coma).
}
  \item{behavior}{
Numeric (0-4). Personality and behavior.
0: Normal.
1: Euphoria or anxiety.
2: Inappropriate behavior.
3: Bizarre behavior.
4: None (Coma).
}
  \item{neuromuscular}{
Numeric (0-4). Neuromuscular abnormalities.
0: None.
1: Tremor, apraxia, incoordination.
2: Asterixis (flapping tremor).
3: Asterixis usually present, hyperreflexia.
4: Decerebrate posturing.
}
}
\value{
A list containing:
\item{HE_Grade}{The calculated West Haven Grade (0-4).}
\item{Description}{Clinical description of the assigned grade.}
}
\references{
Vilstrup H, Amodio P, Bajaj J, et al. Hepatic encephalopathy in chronic liver disease: 2014 Practice Guideline by the American Association for the Study of Liver Diseases and the European Association for the Study of the Liver. Hepatology. 2014;60(2):715-735. doi:10.1002/hep.27210
}
\examples{

# Example 1: Grade 2 (Lethargy and Asterixis present)
# Consciousness(2), Intellect(1), Behavior(1), Neuro(2)
hepatic_encephalopathy_grade(2, 1, 1, 2)

# Example 2: Grade 0 (Normal)
hepatic_encephalopathy_grade(0, 0, 0, 0)
}
