\name{injury_severity_score}
\alias{injury_severity_score}
\title{
Injury Severity Score (ISS)
}
\description{
Calculates the Injury Severity Score (ISS) based on the Abbreviated Injury Scale (AIS). The ISS is an anatomical scoring system that provides an overall score for patients with multiple injuries. It is calculated as the sum of the squares of the highest AIS code in each of the three most severely injured body regions.
}
\usage{
injury_severity_score(head_neck_ais, face_ais, chest_ais, abdomen_pelvis_ais,
                      extremities_pelvic_girdle_ais, external_ais)
}
\arguments{
  \item{head_neck_ais}{
Numeric (0-6). Highest AIS severity code for the Head or Neck region.
}
  \item{face_ais}{
Numeric (0-6). Highest AIS severity code for the Face region.
}
  \item{chest_ais}{
Numeric (0-6). Highest AIS severity code for the Chest region.
}
  \item{abdomen_pelvis_ais}{
Numeric (0-6). Highest AIS severity code for the Abdominal or Pelvic contents region.
}
  \item{extremities_pelvic_girdle_ais}{
Numeric (0-6). Highest AIS severity code for the Extremities or Pelvic Girdle region.
}
  \item{external_ais}{
Numeric (0-6). Highest AIS severity code for External injuries.
}
}
\details{
\strong{AIS Severity Codes:}
1: Minor
2: Moderate
3: Serious
4: Severe
5: Critical
6: Maximal (Unsurvivable)

If any region has an AIS score of 6, the ISS is automatically assigned as 75.
}
\value{
A list containing:
\item{ISS_Score}{The calculated score (Range 1-75).}
\item{Classification}{Trauma severity classification (Minor <9, Moderate 9-15, Serious 16-24, Severe >24).}
}
\references{
Baker SP, O'Neill B, Haddon W Jr, Long WB. The injury severity score: a method for describing patients with multiple injuries and evaluating emergency care. J Trauma. 1974;14(3):187-196.
}
\examples{

# Example 1: Major Trauma
# Head 4, Chest 3, Abdomen 2, others 0
# Score = 4^2 + 3^2 + 2^2 = 16 + 9 + 4 = 29
injury_severity_score(4, 0, 3, 2, 0, 0)

# Example 2: Automatic 75
# Head 6 (Unsurvivable)
# Score = 75
injury_severity_score(6, 2, 2, 0, 0, 0)
}
