\name{intrauterine_rbc_transfusion}
\alias{intrauterine_rbc_transfusion}
\title{
Intrauterine RBC Transfusion Dosage
}
\description{
Calculates the volume of donor red blood cells (RBC) required for an intrauterine transfusion to treat fetal anemia. The calculation estimates the feto-placental blood volume based on fetal weight and uses the hematocrit difference to determine the necessary volume.
}
\usage{
intrauterine_rbc_transfusion(fetal_weight_grams, current_hematocrit,
                             target_hematocrit, donor_hematocrit = 80)
}
\arguments{
  \item{fetal_weight_grams}{
Numeric. Estimated fetal weight in grams.
}
  \item{current_hematocrit}{
Numeric. Current fetal hematocrit (pre-transfusion) percentage.
}
  \item{target_hematocrit}{
Numeric. Desired post-transfusion hematocrit percentage (typically 40-50\%).
}
  \item{donor_hematocrit}{
Numeric. Hematocrit of the donor RBC unit. Defaults to 80\% (typical for packed RBCs prepared for IUT).
}
}
\details{
Formula:
\deqn{Volume_{transfuse} = V_{feto-placental} \times \frac{Hct_{target} - Hct_{current}}{Hct_{donor} - Hct_{current}}}
Where \eqn{V_{feto-placental}} is estimated as \eqn{Weight_{fetal} \times 0.14}.
}
\value{
A list containing:
\item{Volume_to_Transfuse_mL}{The calculated volume of donor blood to administer.}
\item{Estimated_FetoPlacental_Volume_mL}{The estimated total blood volume of the fetus and placenta.}
}
\references{
Mandelbrot L, Daffos F, Forestier F, et al. Assessment of fetal blood volume for computer-assisted management of in utero transfusion. Fetal Diagn Ther. 1988;3(1):60-66. doi:10.1159/000263338
}
\examples{

# Example 1: Severe Anemia
# 1000g fetus, Hct 20 -> 45, Donor Hct 80
intrauterine_rbc_transfusion(1000, 20, 45, 80)

# Example 2: Moderate Anemia
# 1500g fetus, Hct 30 -> 45, Donor Hct 75
intrauterine_rbc_transfusion(1500, 30, 45, 75)
}
