\name{irae_hypothyroidism_grading}
\alias{irae_hypothyroidism_grading}
\title{
irAE Grading for Hypothyroidism
}
\description{
Calculates the CTCAE severity grade for hypothyroidism associated with immune checkpoint inhibitor (ICPi) therapy. Grading relies on the presence of symptoms, the impact on Activities of Daily Living (ADL), and the presence of life-threatening consequences (e.g., myxedema coma).
}
\usage{
irae_hypothyroidism_grading(symptomatic, adl_limitation, life_threatening)
}
\arguments{
  \item{symptomatic}{
Numeric (0 or 1). Are symptoms present? (1 = Yes).
}
  \item{adl_limitation}{
Numeric (0, 1, or 2). Limitation of Activities of Daily Living.
0: No limitation.
1: Limiting instrumental ADL (e.g., preparing meals, shopping).
2: Limiting self-care ADL (e.g., bathing, dressing, feeding).
}
  \item{life_threatening}{
Numeric (0 or 1). Are there life-threatening consequences? (1 = Yes).
}
}
\value{
A list containing:
\item{CTCAE_Grade}{The calculated adverse event grade (1-4).}
\item{Definition}{Clinical description of the grade.}
\item{Management_Recommendation}{Guidance on ICPi continuation and thyroid replacement based on ASCO guidelines.}
}
\references{
Brahmer JR, Lacchetti C, Schneider BJ, et al. Management of Immune-Related Adverse Events in Patients Treated With Immune Checkpoint Inhibitor Therapy: American Society of Clinical Oncology Clinical Practice Guideline. J Clin Oncol. 2018;36(17):1714-1768. doi:10.1200/JCO.2017.77.6385
}
\examples{

# Example 1: Grade 2 (Symptomatic)
# Symptoms Present, Instrumental ADL limited, Not life-threatening
irae_hypothyroidism_grading(1, 1, 0)

# Example 2: Grade 1 (Asymptomatic)
# TSH elevated but patient feels fine
irae_hypothyroidism_grading(0, 0, 0)
}
