\name{itas2010_score}
\alias{itas2010_score}
\title{
Indian Takayasu Clinical Activity Score (ITAS2010)
}
\description{
Calculates the ITAS2010 and ITAS-A scores to assess disease activity in patients with Takayasu Arteritis. The score assigns weighted points to new or worsening clinical features across systemic, cardiovascular, neurologic, renal, and other domains. A score of 1 or greater indicates active disease. The ITAS-A includes acute phase reactants (ESR/CRP) for enhanced sensitivity.
}
\usage{
itas2010_score(systemic_symptoms, arthralgia, carotidynia, pulse_deficit, bruit,
               bp_discrepancy, claudication, hypertension, dyspnea, abdominal_pain,
               cutaneous_lesions, aortic_regurgitation, angina, heart_failure,
               syncope, tia, renal_failure, stroke, myocardial_infarction,
               bowel_ischemia, esr_crp_elevated = 0)
}
\arguments{
  \item{systemic_symptoms}{Numeric (0/1). Fever, malaise, or weight loss. (+1 pt).}
  \item{arthralgia}{Numeric (0/1). Arthralgia or myalgia. (+1 pt).}
  \item{carotidynia}{Numeric (0/1). Carotid tenderness. (+1 pt).}
  \item{pulse_deficit}{Numeric (0/1). Absent or unequal pulse. (+1 pt).}
  \item{bruit}{Numeric (0/1). Audible bruit. (+1 pt).}
  \item{bp_discrepancy}{Numeric (0/1). Blood pressure discrepancy between limbs. (+1 pt).}
  \item{claudication}{Numeric (0/1). Limb claudication. (+1 pt).}
  \item{hypertension}{Numeric (0/1). New or worsening hypertension. (+1 pt).}
  \item{dyspnea}{Numeric (0/1). Dyspnea or pleurisy. (+1 pt).}
  \item{abdominal_pain}{Numeric (0/1). Abdominal pain or nausea/vomiting. (+1 pt).}
  \item{cutaneous_lesions}{Numeric (0/1). Erythema nodosum or ulcers. (+1 pt).}
  \item{aortic_regurgitation}{Numeric (0/1). New or worsening AR. (+3 pts).}
  \item{angina}{Numeric (0/1). Angina pectoris. (+3 pts).}
  \item{heart_failure}{Numeric (0/1). Congestive heart failure. (+3 pts).}
  \item{syncope}{Numeric (0/1). Syncope or dizziness/vertigo. (+3 pts).}
  \item{tia}{Numeric (0/1). Transient Ischemic Attack or visual disturbance. (+3 pts).}
  \item{renal_failure}{Numeric (0/1). Renal failure. (+3 pts).}
  \item{stroke}{Numeric (0/1). Stroke. (+5 pts).}
  \item{myocardial_infarction}{Numeric (0/1). Myocardial infarction. (+5 pts).}
  \item{bowel_ischemia}{Numeric (0/1). Ischemic bowel. (+5 pts).}
  \item{esr_crp_elevated}{Numeric (0/1). Elevated ESR or CRP (for ITAS-A). (+1 pt).}
}
\value{
A list containing:
\item{ITAS2010_Score}{The clinical activity score (Clinical features only).}
\item{ITAS_A_Score}{The activity score including acute phase reactants.}
\item{Disease_Status}{"Active" if score >= 1, otherwise "Inactive".}
}
\references{
Misra DP, Rathore U, Patro P, et al. Disease Activity Indices in Takayasu Arteritis: A Systematic Review and Meta-Analysis. Rheumatol Ther. 2021.
Jayakumar P, et al. Development and validation of the Indian Takayasu Clinical Activity Score (ITAS2010). Indian J Rheumatol. 2010.
}
\examples{

# Example 1: Active Disease
# Pulse deficit (+1), Claudication (+1), Elevated ESR (+1)
# ITAS2010 = 2, ITAS-A = 3
itas2010_score(0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1)

# Example 2: Severe Activity
# Stroke (+5), Hypertension (+1)
# ITAS2010 = 6
itas2010_score(0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0)
}
