\name{lent_prognostic_score}
\alias{lent_prognostic_score}
\title{
LENT Prognostic Score for Malignant Pleural Effusion
}
\description{
Calculates the LENT score (Pleural fluid LDH, ECOG performance status, Neutrophil-to-lymphocyte ratio, Tumor type) to predict survival in patients with malignant pleural effusion. It stratifies patients into Low, Moderate, and High risk groups.
}
\usage{
lent_prognostic_score(pleural_ldh, ecog_score, serum_nlr, tumor_type)
}
\arguments{
  \item{pleural_ldh}{
Numeric. Lactate dehydrogenase level in pleural fluid (IU/L). (> 1500 IU/L adds 1 point).
}
  \item{ecog_score}{
Numeric (0-4). Eastern Cooperative Oncology Group performance status.
0: 0 pts.
1: 1 pt.
2: 2 pts.
3-4: 3 pts.
}
  \item{serum_nlr}{
Numeric. Serum neutrophil-to-lymphocyte ratio. (> 9 adds 1 point).
}
  \item{tumor_type}{
String. Primary tumor type.
"mesothelioma", "hematologic": 0 pts (Low risk).
"breast", "gynecologic", "renal", "sarcoma": 1 pt (Moderate risk).
"lung", "other": 2 pts (High risk).
}
}
\value{
A list containing:
\item{LENT_Score}{The calculated total score (Range 0-7).}
\item{Risk_Category}{Classification (Low 0-1, Moderate 2-4, High 5-7).}
\item{Median_Survival}{Estimated median survival time in days/months.}
}
\references{
Clive AO, Kahan BC, Hooper CE, et al. Predicting survival in malignant pleural effusion: development and validation of the LENT prognostic score. Thorax. 2014;69(12):1098-1104. doi:10.1136/thoraxjnl-2014-205285
}
\examples{

# Example 1: Low Risk
# LDH 1000, ECOG 0, NLR 5, Breast Cancer
# Score = 0 + 0 + 0 + 1 = 1
lent_prognostic_score(1000, 0, 5, "breast")

# Example 2: High Risk
# LDH 2000 (+1), ECOG 3 (+3), NLR 12 (+1), Lung Cancer (+2)
# Score = 7
lent_prognostic_score(2000, 3, 12, "lung")
}
