\name{licurse_renal_ultrasound_score}
\alias{licurse_renal_ultrasound_score}
\title{
Licurse Score for Renal Ultrasound in AKI
}
\description{
Calculates the Licurse Score to stratify the utility of renal ultrasonography (RUS) in patients presenting with Acute Kidney Injury (AKI). The score identifies patients at low risk for hydronephrosis (post-renal obstruction), potentially reducing unnecessary imaging.
}
\usage{
licurse_renal_ultrasound_score(age_ge_65, male_sex, history_hydronephrosis,
                               history_chf)
}
\arguments{
  \item{age_ge_65}{
Numeric (0 or 1). Is the patient 65 years of age or older? (1 = Yes, +1 point).
}
  \item{male_sex}{
Numeric (0 or 1). Is the patient male? (1 = Yes, +1 point).
}
  \item{history_hydronephrosis}{
Numeric (0 or 1). Does the patient have a known history of hydronephrosis? (1 = Yes, +1 point).
}
  \item{history_chf}{
Numeric (0 or 1). Does the patient have a history of Congestive Heart Failure? (1 = Yes, -1 point).
}
}
\value{
A list containing:
\item{Licurse_Score}{The calculated score (Range -1 to 3).}
\item{Risk_Category}{Classification of risk (Low, Intermediate, High, Very High).}
\item{Prob_Hydronephrosis}{Estimated probability of detecting hydronephrosis on ultrasound.}
\item{Recommendation}{Guidance on the necessity of imaging.}
}
\references{
Licurse A, Kim MC, Dziura J, et al. Renal ultrasonography in the evaluation of acute kidney injury: developing a clinical prediction rule. Arch Intern Med. 2010;170(15):1317-1321. doi:10.1001/archinternmed.2010.240
}
\examples{

# Example 1: Low Risk (No imaging needed)
# 40yo Female, No Hx Hydro, Hx CHF
# Score = 0 + 0 + 0 - 1 = -1
licurse_renal_ultrasound_score(0, 0, 0, 1)

# Example 2: High Risk
# 70yo Male, No Hx Hydro, No CHF
# Score = 1 + 1 + 0 + 0 = 2
licurse_renal_ultrasound_score(1, 1, 0, 0)
}
