\name{malt_ipi_score}
\alias{malt_ipi_score}
\title{
MALT Lymphoma International Prognostic Index (MALT-IPI)
}
\description{
Calculates the MALT-IPI score to predict event-free survival (EFS) in patients with MALT lymphoma. The index uses three adverse prognostic factors: Age >= 70 years, Ann Arbor Stage III or IV, and elevated serum LDH.
}
\usage{
malt_ipi_score(age, ann_arbor_stage, ldh_elevated)
}
\arguments{
  \item{age}{
Numeric. Patient age in years. (>= 70 years adds 1 point).
}
  \item{ann_arbor_stage}{
Numeric (1-4). Ann Arbor Stage. (Stage III or IV adds 1 point).
}
  \item{ldh_elevated}{
Numeric (0 or 1). Serum LDH level greater than the upper limit of normal. (1 = Yes, +1 point).
}
}
\value{
A list containing:
\item{MALT_IPI_Score}{The calculated score (Range 0-3).}
\item{Risk_Group}{Classification (Low: 0, Intermediate: 1, High: >=2).}
\item{Est_5_Year_Event_Free_Survival}{Estimated 5-year event-free survival probability.}
}
\references{
Thieblemont C, Cascín-Medina A, Bertoni F, et al. A MALT lymphoma prognostic index. Blood. 2017;130(12):1409-1417. doi:10.1182/blood-2017-03-771915
}
\examples{

# Example 1: High Risk
# 75yo (+1), Stage IV (+1), Normal LDH (0)
# Score = 2
malt_ipi_score(75, 4, 0)

# Example 2: Low Risk
# 60yo (0), Stage I (0), Normal LDH (0)
# Score = 0
malt_ipi_score(60, 1, 0)
}
