\name{meld_na_score_liver}
\alias{meld_na_score_liver}
\title{
MELD-Na Score for Liver Cirrhosis
}
\description{
Calculates the MELD-Na (Model for End-Stage Liver Disease including Sodium) score. This version, adopted by OPTN/UNOS in 2016, incorporates serum sodium to better predict 3-month mortality in patients with end-stage liver disease, particularly those with hyponatremia.
}
\usage{
meld_na_score_liver(bilirubin, inr, creatinine, sodium, on_dialysis = 0,
                    bilirubin_units = "mg/dL", creatinine_units = "mg/dL")
}
\arguments{
  \item{bilirubin}{
Numeric. Total Bilirubin level.
}
  \item{inr}{
Numeric. International Normalized Ratio.
}
  \item{creatinine}{
Numeric. Serum Creatinine level.
}
  \item{sodium}{
Numeric. Serum Sodium level (mEq/L).
}
  \item{on_dialysis}{
Numeric (0 or 1). Has the patient had dialysis at least twice in the past week? (1 = Yes). If Yes, creatinine is set to 4.0 mg/dL.
}
  \item{bilirubin_units}{
String. Units for bilirubin input. "mg/dL" (default) or "umol/L".
}
  \item{creatinine_units}{
String. Units for creatinine input. "mg/dL" (default) or "umol/L".
}
}
\value{
A list containing:
\item{MELD_Na_Score}{The calculated MELD-Na score (Range 6-40).}
\item{Est_3_Month_Mortality}{Estimated 3-month mortality percentage.}
}
\references{
Kim WR, Biggins SW, Kremers WK, et al. Hyponatremia and mortality among patients on the liver-transplant waiting list. N Engl J Med. 2008;359(10):1018-1026. doi:10.1056/NEJMoa0801209
OPTN/UNOS Policy Notice. Liver Policy: MELD Score / MELD-Na Score. 2016.
}
\examples{

# Example 1: High Risk (Hyponatremia Effect)
# Bili 2.0, INR 1.5, Cr 1.5, Na 125 (Low Na increases score)
meld_na_score_liver(2.0, 1.5, 1.5, 125, 0)

# Example 2: Standard Risk
# Bili 1.0, INR 1.0, Cr 1.0, Na 138 (Na capped at 137)
# Score = 6
meld_na_score_liver(1.0, 1.0, 1.0, 138, 0)
}
