\name{midas_migraine_score}
\alias{midas_migraine_score}
\title{
Migraine Disability Assessment (MIDAS)
}
\description{
Calculates the MIDAS score to evaluate headache-related disability over the past 3 months. The score sums the number of days of lost or significantly reduced activity across three domains: work/school, household work, and family/social activities.
}
\usage{
midas_migraine_score(missed_work_school, reduced_work_school, missed_housework,
                     reduced_housework, missed_social_leisure)
}
\arguments{
  \item{missed_work_school}{
Numeric. Days missed from work or school in the last 3 months.
}
  \item{reduced_work_school}{
Numeric. Days with productivity at work or school reduced by half or more (excluding missed days) in the last 3 months.
}
  \item{missed_housework}{
Numeric. Days did not do household work (chores, repairs, shopping, caring for family) in the last 3 months.
}
  \item{reduced_housework}{
Numeric. Days with productivity in household work reduced by half or more (excluding missed days) in the last 3 months.
}
  \item{missed_social_leisure}{
Numeric. Days missed family, social, or leisure activities in the last 3 months.
}
}
\value{
A list containing:
\item{MIDAS_Score}{The calculated total score (Sum of days).}
\item{Grade}{The severity grade (I-IV).}
\item{Interpretation}{Description of the disability level (Little/No, Mild, Moderate, Severe).}
}
\references{
Stewart WF, Lipton RB, Dowson AJ, Sawyer J. Development and testing of the Migraine Disability Assessment (MIDAS) Questionnaire to assess headache-related disability. Neurology. 2001;56(6 Suppl 1):S20-28. doi:10.1212/wnl.56.suppl_1.s20
}
\examples{

# Example 1: Severe Disability
# Missed work 5, Reduced work 10, Missed home 5, Reduced home 10, Missed social 5
# Score = 35
midas_migraine_score(5, 10, 5, 10, 5)

# Example 2: Little or No Disability
# Missed work 0, Reduced work 2, Missed home 0, Reduced home 1, Missed social 0
# Score = 3
midas_migraine_score(0, 2, 0, 1, 0)
}
