\name{milan_criteria_liver_transplant}
\alias{milan_criteria_liver_transplant}
\title{
Milan Criteria for Liver Transplantation
}
\description{
Determines eligibility for liver transplantation in patients with cirrhosis and hepatocellular carcinoma (HCC) based on the Milan Criteria. These criteria identify patients with small, unresectable HCCs who are likely to have good post-transplant outcomes.
}
\usage{
milan_criteria_liver_transplant(num_tumors, max_tumor_size_cm,
                                extra_hepatic_spread, vascular_invasion)
}
\arguments{
  \item{num_tumors}{
Numeric. Total number of tumor nodules.
}
  \item{max_tumor_size_cm}{
Numeric. Diameter of the largest tumor nodule in centimeters.
}
  \item{extra_hepatic_spread}{
Numeric (0 or 1). Presence of extra-hepatic manifestations (metastases). (1 = Yes).
}
  \item{vascular_invasion}{
Numeric (0 or 1). Presence of macrovascular invasion. (1 = Yes).
}
}
\value{
A list containing:
\item{Result}{Eligibility status ("Eligible" or "Not Eligible").}
\item{Explanation}{The specific rule component that determined the result.}
}
\references{
Mazzaferro V, Regalia E, Doci R, et al. Liver transplantation for the treatment of small hepatocellular carcinomas in patients with cirrhosis. N Engl J Med. 1996;334(11):693-699. doi:10.1056/NEJM199603143341104
}
\examples{

# Example 1: Eligible (Single small tumor)
# 1 tumor, 4.5 cm, No spread/invasion
milan_criteria_liver_transplant(1, 4.5, 0, 0)

# Example 2: Not Eligible (Too large)
# 2 tumors, largest 4.0 cm (Limit for multiple is 3 cm)
milan_criteria_liver_transplant(2, 4.0, 0, 0)

# Example 3: Eligible (Multiple small tumors)
# 3 tumors, largest 2.8 cm
milan_criteria_liver_transplant(3, 2.8, 0, 0)
}
