\name{modified_finnegan_nas_score}
\alias{modified_finnegan_nas_score}
\title{
Modified Finnegan Neonatal Abstinence Score (NAS)
}
\description{
Calculates the Modified Finnegan Score to assess the severity of Neonatal Abstinence Syndrome (NAS) in infants exposed to opioids or other substances in utero. The score evaluates 21 symptoms across CNS, metabolic/vasomotor/respiratory, and gastrointestinal domains.
}
\usage{
modified_finnegan_nas_score(cry_score, sleep_score, moro_reflex_score,
                            tremors_score, increased_muscle_tone, excoriation,
                            myoclonic_jerks, generalized_convulsions, sweating,
                            fever_score, frequent_yawning, mottling, nasal_stuffiness,
                            frequent_sneezing, nasal_flaring, respiration_score,
                            excessive_sucking, poor_feeding, projectile_vomiting,
                            stool_score)
}
\arguments{
  \item{cry_score}{
Numeric. 0: Normal; 2: High pitched; 3: Continuous high pitched.
}
  \item{sleep_score}{
Numeric. 0: Sleeps >3 hours after feeding; 1: Sleeps 2-3 hours; 2: Sleeps 1-2 hours; 3: Sleeps <1 hour.
}
  \item{moro_reflex_score}{
Numeric. 0: Normal; 2: Hyperactive; 3: Markedly hyperactive.
}
  \item{tremors_score}{
Numeric. 0: Normal; 1: Disturbed, mild; 2: Disturbed, marked; 3: Undisturbed, mild; 4: Undisturbed, marked.
}
  \item{increased_muscle_tone}{
Numeric (0 or 1). 1 = Yes (+2 points).
}
  \item{excoriation}{
Numeric (0 or 1). 1 = Yes (+1 point).
}
  \item{myoclonic_jerks}{
Numeric (0 or 1). 1 = Yes (+3 points).
}
  \item{generalized_convulsions}{
Numeric (0 or 1). 1 = Yes (+5 points).
}
  \item{sweating}{
Numeric (0 or 1). 1 = Yes (+1 point).
}
  \item{fever_score}{
Numeric. 0: <37.2 C; 1: 37.2-38.3 C; 2: >38.4 C.
}
  \item{frequent_yawning}{
Numeric (0 or 1). >3-4 times/interval. (1 = Yes, +1 point).
}
  \item{mottling}{
Numeric (0 or 1). 1 = Yes (+1 point).
}
  \item{nasal_stuffiness}{
Numeric (0 or 1). 1 = Yes (+1 point).
}
  \item{frequent_sneezing}{
Numeric (0 or 1). >3-4 times/interval. (1 = Yes, +1 point).
}
  \item{nasal_flaring}{
Numeric (0 or 1). 1 = Yes (+2 points).
}
  \item{respiration_score}{
Numeric. 0: <60/min; 1: >60/min; 2: >60/min with retractions.
}
  \item{excessive_sucking}{
Numeric (0 or 1). 1 = Yes (+1 point).
}
  \item{poor_feeding}{
Numeric (0 or 1). Infrequent/uncoordinated feeding. (1 = Yes, +2 points).
}
  \item{projectile_vomiting}{
Numeric (0 or 1). 1 = Yes (+2 points).
}
  \item{stool_score}{
Numeric. 0: Normal; 2: Loose; 3: Watery.
}
}
\value{
A list containing:
\item{NAS_Score}{The calculated total score.}
\item{Recommendation}{General clinical guidance based on the score threshold of 8.}
}
\references{
Finnegan LP, Connaughton JF Jr, Kron RE, Emich JP. Neonatal abstinence syndrome: assessment and management. Addict Dis. 1975;2(1-2):141-158.
}
\examples{

# Example 1: Moderate Withdrawal
# High cry (2), Sleep 1-2h (2), Tremors mild dist (1), Sweating (1), Loose stool (2)
modified_finnegan_nas_score(2, 2, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2)

# Example 2: Severe Withdrawal
# Continuous cry (3), Sleep <1h (3), Tremors undisturbed marked (4),
# Fever >38.4 (2), Watery stool (3)
modified_finnegan_nas_score(3, 3, 0, 4, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3)
}
