\name{mtoq_4_score}
\alias{mtoq_4_score}
\title{
Migraine Treatment Optimization Questionnaire (mTOQ-4)
}
\description{
Calculates the mTOQ-4 score to assess the adequacy of acute migraine treatment. The 4-item questionnaire evaluates treatment efficacy (pain-free at 2 hours, function restoration), tolerability (comfortable with side effects), and consistency (sustained relief with single dose). Higher scores indicate better treatment optimization.
}
\usage{
mtoq_4_score(q1_pain_free_2h, q2_function_2h, q3_comfortable_2h, q4_single_dose)
}
\arguments{
  \item{q1_pain_free_2h}{
Numeric (0-4). Are you pain-free at 2 hours? (0=Never, 4=All the time).
}
  \item{q2_function_2h}{
Numeric (0-4). Does your medicine return you to normal function at 2 hours? (0=Never, 4=All the time).
}
  \item{q3_comfortable_2h}{
Numeric (0-4). Are you comfortable with your medicine's side effects? (0=Never, 4=All the time).
}
  \item{q4_single_dose}{
Numeric (0-4). Does one dose work for 24 hours? (0=Never, 4=All the time).
}
}
\details{
\strong{Scoring Key:}
0 = Never
1 = Rarely
2 = Less than half the time
3 = More than half the time
4 = All the time
}
\value{
A list containing:
\item{mTOQ_4_Score}{The calculated total score (Range 0-16).}
\item{Optimization_Status}{Interpretation of treatment optimization.}
}
\references{
Lipton RB, Kolodner K, Bigal ME, et al. Validity and reliability of the Migraine-Treatment Optimization Questionnaire. Cephalalgia. 2009;29(7):751-759. doi:10.1111/j.1468-2982.2008.01785.x
}
\examples{

# Example 1: Optimal Treatment
# All the time (4) for all questions
mtoq_4_score(4, 4, 4, 4)

# Example 2: Poor Optimization
# Rarely (1) for efficacy, sometimes (2) for others
mtoq_4_score(1, 1, 2, 2)
}
