\name{mulbsta_score}
\alias{mulbsta_score}
\title{
MuLBSTA Score for Viral Pneumonia Mortality
}
\description{
Calculates the MuLBSTA score to predict 90-day mortality in patients with viral pneumonia. The score uses six clinical and laboratory variables: Multilobular infiltration, Lymphocytes, Bacterial coinfection, Smoking history, hypertension, and Age.
}
\usage{
mulbsta_score(multilobular_infiltration, lymphocyte_count, bacterial_coinfection,
              smoking_history, hypertension_history, age)
}
\arguments{
  \item{multilobular_infiltration}{
Numeric (0 or 1). Presence of multilobular infiltrates on chest imaging. (1 = Yes, +5 points).
}
  \item{lymphocyte_count}{
Numeric. Absolute lymphocyte count in x10^9/L. (<= 0.8 x 10^9/L adds +4 points).
}
  \item{bacterial_coinfection}{
Numeric (0 or 1). Presence of bacterial co-infection. (1 = Yes, +4 points).
}
  \item{smoking_history}{
Numeric (0 or 1). History of smoking (current or former). (1 = Yes, +3 points).
}
  \item{hypertension_history}{
Numeric (0 or 1). History of hypertension. (1 = Yes, +2 points).
}
  \item{age}{
Numeric. Patient age in years. (>= 60 years adds +2 points).
}
}
\value{
A list containing:
\item{MuLBSTA_Score}{The calculated total score (Range 0-20).}
\item{Risk_Category}{Classification (Low Risk <= 11, High Risk >= 12).}
\item{Mortality_Risk_90_Day}{Estimated 90-day mortality risk.}
}
\references{
Guo L, Wei D, Zhang X, et al. Clinical Features Predicting Mortality Risk in Patients With Viral Pneumonia: The MuLBSTA Score. Front Microbiol. 2019;10:2752. doi:10.3389/fmicb.2019.02752
}
\examples{

# Example 1: High Risk
# Multilobular (+5), Lymphocytes 0.5 (+4), Age 65 (+2), Smoker (+3)
# Score = 14
mulbsta_score(1, 0.5, 0, 1, 0, 65)

# Example 2: Low Risk
# Unilobular (0), Lymphocytes 1.5 (0), No bacteria, No smoker, HTN (+2), Age 50
# Score = 2
mulbsta_score(0, 1.5, 0, 0, 1, 50)
}
