\name{nexus_chest_ct_rule}
\alias{nexus_chest_ct_rule}
\title{
NEXUS Chest CT Decision Instrument
}
\description{
Calculates the NEXUS Chest CT result to determine the need for chest CT imaging in blunt trauma patients (>14 years old) evaluated within 6 hours of injury. If any one of the seven criteria is present, the patient is not considered low risk, and imaging is indicated.
}
\usage{
nexus_chest_ct_rule(age, rapid_deceleration, chest_pain, intoxication,
                    abnormal_alertness, distracting_injury, chest_wall_tenderness)
}
\arguments{
  \item{age}{
Numeric. Patient age in years. (Age > 60 is a risk factor).
}
  \item{rapid_deceleration}{
Numeric (0 or 1). Mechanism of rapid deceleration (e.g., fall > 20 ft / 6 m, or MVA > 40 mph / 64 kph with sudden deceleration). (1 = Yes).
}
  \item{chest_pain}{
Numeric (0 or 1). Presence of chest pain. (1 = Yes).
}
  \item{intoxication}{
Numeric (0 or 1). Is the patient intoxicated? (1 = Yes).
}
  \item{abnormal_alertness}{
Numeric (0 or 1). Abnormal alertness or mental status (GCS < 15 or disorientation). (1 = Yes).
}
  \item{distracting_injury}{
Numeric (0 or 1). Presence of a distracting painful injury. (1 = Yes).
}
  \item{chest_wall_tenderness}{
Numeric (0 or 1). Tenderness to chest wall palpation. (1 = Yes).
}
}
\value{
A list containing:
\item{Result}{Recommendation regarding the indication for Chest CT ("Indicated" or "Not Indicated").}
\item{Inputs}{A summary of the criteria evaluated.}
}
\references{
Rodriguez RM, et al. Derivation and validation of two decision instruments for selective chest CT in blunt trauma: a multicenter prospective observational study (NEXUS Chest CT). PLoS Med. 2015;12(10):e1001883. doi:10.1371/journal.pmed.1001883
}
\examples{

# Example 1: Low Risk
# 30yo, Fall <10ft, No pain, Alert, No other injuries
nexus_chest_ct_rule(30, 0, 0, 0, 0, 0, 0)

# Example 2: Indicated (Chest pain)
# 45yo, MVA, Chest pain present
nexus_chest_ct_rule(45, 1, 1, 0, 0, 0, 0)
}
